/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAssetResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DeleteAssetResponse.Builder, DeleteAssetResponse> {
    private static final SdkField<AssetStatus> ASSET_STATUS_FIELD = SdkField.<AssetStatus> builder(MarshallingType.SDK_POJO)
            .memberName("assetStatus").getter(getter(DeleteAssetResponse::assetStatus)).setter(setter(Builder::assetStatus))
            .constructor(AssetStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_STATUS_FIELD));

    private final AssetStatus assetStatus;

    private DeleteAssetResponse(BuilderImpl builder) {
        super(builder);
        this.assetStatus = builder.assetStatus;
    }

    /**
     * <p>
     * The status of the asset, which contains a state (<code>DELETING</code> after successfully calling this operation)
     * and any error message.
     * </p>
     * 
     * @return The status of the asset, which contains a state (<code>DELETING</code> after successfully calling this
     *         operation) and any error message.
     */
    public final AssetStatus assetStatus() {
        return assetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAssetResponse)) {
            return false;
        }
        DeleteAssetResponse other = (DeleteAssetResponse) obj;
        return Objects.equals(assetStatus(), other.assetStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAssetResponse").add("AssetStatus", assetStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetStatus":
            return Optional.ofNullable(clazz.cast(assetStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAssetResponse, T> g) {
        return obj -> g.apply((DeleteAssetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAssetResponse> {
        /**
         * <p>
         * The status of the asset, which contains a state (<code>DELETING</code> after successfully calling this
         * operation) and any error message.
         * </p>
         * 
         * @param assetStatus
         *        The status of the asset, which contains a state (<code>DELETING</code> after successfully calling this
         *        operation) and any error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetStatus(AssetStatus assetStatus);

        /**
         * <p>
         * The status of the asset, which contains a state (<code>DELETING</code> after successfully calling this
         * operation) and any error message.
         * </p>
         * This is a convenience that creates an instance of the {@link AssetStatus.Builder} avoiding the need to create
         * one manually via {@link AssetStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssetStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #assetStatus(AssetStatus)}.
         * 
         * @param assetStatus
         *        a consumer that will call methods on {@link AssetStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetStatus(AssetStatus)
         */
        default Builder assetStatus(Consumer<AssetStatus.Builder> assetStatus) {
            return assetStatus(AssetStatus.builder().applyMutation(assetStatus).build());
        }
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private AssetStatus assetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAssetResponse model) {
            super(model);
            assetStatus(model.assetStatus);
        }

        public final AssetStatus.Builder getAssetStatus() {
            return assetStatus != null ? assetStatus.toBuilder() : null;
        }

        @Override
        public final Builder assetStatus(AssetStatus assetStatus) {
            this.assetStatus = assetStatus;
            return this;
        }

        public final void setAssetStatus(AssetStatus.BuilderImpl assetStatus) {
            this.assetStatus = assetStatus != null ? assetStatus.build() : null;
        }

        @Override
        public DeleteAssetResponse build() {
            return new DeleteAssetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
