/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an asset model property.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetModelProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetModelProperty.Builder, AssetModelProperty> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssetModelProperty::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssetModelProperty::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(AssetModelProperty::dataTypeAsString)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> DATA_TYPE_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataTypeSpec").getter(getter(AssetModelProperty::dataTypeSpec)).setter(setter(Builder::dataTypeSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTypeSpec").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(AssetModelProperty::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<PropertyType> TYPE_FIELD = SdkField.<PropertyType> builder(MarshallingType.SDK_POJO)
            .memberName("type").getter(getter(AssetModelProperty::type)).setter(setter(Builder::type))
            .constructor(PropertyType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DATA_TYPE_FIELD, DATA_TYPE_SPEC_FIELD, UNIT_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String dataType;

    private final String dataTypeSpec;

    private final String unit;

    private final PropertyType type;

    private AssetModelProperty(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.dataTypeSpec = builder.dataTypeSpec;
        this.unit = builder.unit;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID of the asset model property.
     * </p>
     * 
     * @return The ID of the asset model property.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the asset model property.
     * </p>
     * 
     * @return The name of the asset model property.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The data type of the asset model property.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link PropertyDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the asset model property.
     * @see PropertyDataType
     */
    public final PropertyDataType dataType() {
        return PropertyDataType.fromValue(dataType);
    }

    /**
     * <p>
     * The data type of the asset model property.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link PropertyDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the asset model property.
     * @see PropertyDataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * The data type of the structure for this property. This parameter exists on properties that have the
     * <code>STRUCT</code> data type.
     * </p>
     * 
     * @return The data type of the structure for this property. This parameter exists on properties that have the
     *         <code>STRUCT</code> data type.
     */
    public final String dataTypeSpec() {
        return dataTypeSpec;
    }

    /**
     * <p>
     * The unit of the asset model property, such as <code>Newtons</code> or <code>RPM</code>.
     * </p>
     * 
     * @return The unit of the asset model property, such as <code>Newtons</code> or <code>RPM</code>.
     */
    public final String unit() {
        return unit;
    }

    /**
     * <p>
     * The property type (see <code>PropertyType</code>).
     * </p>
     * 
     * @return The property type (see <code>PropertyType</code>).
     */
    public final PropertyType type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeSpec());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetModelProperty)) {
            return false;
        }
        AssetModelProperty other = (AssetModelProperty) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(dataTypeAsString(), other.dataTypeAsString())
                && Objects.equals(dataTypeSpec(), other.dataTypeSpec()) && Objects.equals(unit(), other.unit())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetModelProperty").add("Id", id()).add("Name", name()).add("DataType", dataTypeAsString())
                .add("DataTypeSpec", dataTypeSpec()).add("Unit", unit()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "dataTypeSpec":
            return Optional.ofNullable(clazz.cast(dataTypeSpec()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetModelProperty, T> g) {
        return obj -> g.apply((AssetModelProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetModelProperty> {
        /**
         * <p>
         * The ID of the asset model property.
         * </p>
         * 
         * @param id
         *        The ID of the asset model property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the asset model property.
         * </p>
         * 
         * @param name
         *        The name of the asset model property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data type of the asset model property.
         * </p>
         * 
         * @param dataType
         *        The data type of the asset model property.
         * @see PropertyDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyDataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The data type of the asset model property.
         * </p>
         * 
         * @param dataType
         *        The data type of the asset model property.
         * @see PropertyDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyDataType
         */
        Builder dataType(PropertyDataType dataType);

        /**
         * <p>
         * The data type of the structure for this property. This parameter exists on properties that have the
         * <code>STRUCT</code> data type.
         * </p>
         * 
         * @param dataTypeSpec
         *        The data type of the structure for this property. This parameter exists on properties that have the
         *        <code>STRUCT</code> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTypeSpec(String dataTypeSpec);

        /**
         * <p>
         * The unit of the asset model property, such as <code>Newtons</code> or <code>RPM</code>.
         * </p>
         * 
         * @param unit
         *        The unit of the asset model property, such as <code>Newtons</code> or <code>RPM</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * The property type (see <code>PropertyType</code>).
         * </p>
         * 
         * @param type
         *        The property type (see <code>PropertyType</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(PropertyType type);

        /**
         * <p>
         * The property type (see <code>PropertyType</code>).
         * </p>
         * This is a convenience that creates an instance of the {@link PropertyType.Builder} avoiding the need to
         * create one manually via {@link PropertyType#builder()}.
         *
         * When the {@link Consumer} completes, {@link PropertyType.Builder#build()} is called immediately and its
         * result is passed to {@link #type(PropertyType)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link PropertyType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(PropertyType)
         */
        default Builder type(Consumer<PropertyType.Builder> type) {
            return type(PropertyType.builder().applyMutation(type).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String dataType;

        private String dataTypeSpec;

        private String unit;

        private PropertyType type;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetModelProperty model) {
            id(model.id);
            name(model.name);
            dataType(model.dataType);
            dataTypeSpec(model.dataTypeSpec);
            unit(model.unit);
            type(model.type);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDataType() {
            return dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(PropertyDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getDataTypeSpec() {
            return dataTypeSpec;
        }

        @Override
        public final Builder dataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
            return this;
        }

        public final void setDataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final PropertyType.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        @Override
        public final Builder type(PropertyType type) {
            this.type = type;
            return this;
        }

        public final void setType(PropertyType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public AssetModelProperty build() {
            return new AssetModelProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
