/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.ConfigurationErrorDetails;
import software.amazon.awssdk.services.iotsitewise.model.ConfigurationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ConfigurationStatus.getter(ConfigurationStatus::stateAsString)).setter(ConfigurationStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<ConfigurationErrorDetails> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(ConfigurationStatus.getter(ConfigurationStatus::error)).setter(ConfigurationStatus.setter(Builder::error)).constructor(ConfigurationErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String state;
    private final ConfigurationErrorDetails error;

    private ConfigurationStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.error = builder.error;
    }

    public final ConfigurationState state() {
        return ConfigurationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final ConfigurationErrorDetails error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationStatus)) {
            return false;
        }
        ConfigurationStatus other = (ConfigurationStatus)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationStatus").add("State", (Object)this.stateAsString()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationStatus, T> g) {
        return obj -> g.apply((ConfigurationStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private ConfigurationErrorDetails error;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationStatus model) {
            this.state(model.state);
            this.error(model.error);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ConfigurationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final ConfigurationErrorDetails.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        @Override
        public final Builder error(ConfigurationErrorDetails error) {
            this.error = error;
            return this;
        }

        public final void setError(ConfigurationErrorDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        public ConfigurationStatus build() {
            return new ConfigurationStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationStatus> {
        public Builder state(String var1);

        public Builder state(ConfigurationState var1);

        public Builder error(ConfigurationErrorDetails var1);

        default public Builder error(Consumer<ConfigurationErrorDetails.Builder> error) {
            return this.error((ConfigurationErrorDetails)((ConfigurationErrorDetails.Builder)ConfigurationErrorDetails.builder().applyMutation(error)).build());
        }
    }
}

