/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotsitewise.model.AuthMode;
import software.amazon.awssdk.services.iotsitewise.model.ImageFile;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePortalRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, CreatePortalRequest> {
    private static final SdkField<String> PORTAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalName").getter(CreatePortalRequest.getter(CreatePortalRequest::portalName)).setter(CreatePortalRequest.setter(Builder::portalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalName").build()}).build();
    private static final SdkField<String> PORTAL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalDescription").getter(CreatePortalRequest.getter(CreatePortalRequest::portalDescription)).setter(CreatePortalRequest.setter(Builder::portalDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalDescription").build()}).build();
    private static final SdkField<String> PORTAL_CONTACT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalContactEmail").getter(CreatePortalRequest.getter(CreatePortalRequest::portalContactEmail)).setter(CreatePortalRequest.setter(Builder::portalContactEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalContactEmail").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreatePortalRequest.getter(CreatePortalRequest::clientToken)).setter(CreatePortalRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<ImageFile> PORTAL_LOGO_IMAGE_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("portalLogoImageFile").getter(CreatePortalRequest.getter(CreatePortalRequest::portalLogoImageFile)).setter(CreatePortalRequest.setter(Builder::portalLogoImageFile)).constructor(ImageFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalLogoImageFile").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreatePortalRequest.getter(CreatePortalRequest::roleArn)).setter(CreatePortalRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreatePortalRequest.getter(CreatePortalRequest::tags)).setter(CreatePortalRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PORTAL_AUTH_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalAuthMode").getter(CreatePortalRequest.getter(CreatePortalRequest::portalAuthModeAsString)).setter(CreatePortalRequest.setter(Builder::portalAuthMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalAuthMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_NAME_FIELD, PORTAL_DESCRIPTION_FIELD, PORTAL_CONTACT_EMAIL_FIELD, CLIENT_TOKEN_FIELD, PORTAL_LOGO_IMAGE_FILE_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, PORTAL_AUTH_MODE_FIELD));
    private final String portalName;
    private final String portalDescription;
    private final String portalContactEmail;
    private final String clientToken;
    private final ImageFile portalLogoImageFile;
    private final String roleArn;
    private final Map<String, String> tags;
    private final String portalAuthMode;

    private CreatePortalRequest(BuilderImpl builder) {
        super(builder);
        this.portalName = builder.portalName;
        this.portalDescription = builder.portalDescription;
        this.portalContactEmail = builder.portalContactEmail;
        this.clientToken = builder.clientToken;
        this.portalLogoImageFile = builder.portalLogoImageFile;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.portalAuthMode = builder.portalAuthMode;
    }

    public String portalName() {
        return this.portalName;
    }

    public String portalDescription() {
        return this.portalDescription;
    }

    public String portalContactEmail() {
        return this.portalContactEmail;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public ImageFile portalLogoImageFile() {
        return this.portalLogoImageFile;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public AuthMode portalAuthMode() {
        return AuthMode.fromValue(this.portalAuthMode);
    }

    public String portalAuthModeAsString() {
        return this.portalAuthMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.portalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalContactEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalLogoImageFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.portalAuthModeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortalRequest)) {
            return false;
        }
        CreatePortalRequest other = (CreatePortalRequest)((Object)obj);
        return Objects.equals(this.portalName(), other.portalName()) && Objects.equals(this.portalDescription(), other.portalDescription()) && Objects.equals(this.portalContactEmail(), other.portalContactEmail()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.portalLogoImageFile(), other.portalLogoImageFile()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.portalAuthModeAsString(), other.portalAuthModeAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreatePortalRequest").add("PortalName", (Object)this.portalName()).add("PortalDescription", (Object)this.portalDescription()).add("PortalContactEmail", (Object)this.portalContactEmail()).add("ClientToken", (Object)this.clientToken()).add("PortalLogoImageFile", (Object)this.portalLogoImageFile()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("PortalAuthMode", (Object)this.portalAuthModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portalName": {
                return Optional.ofNullable(clazz.cast(this.portalName()));
            }
            case "portalDescription": {
                return Optional.ofNullable(clazz.cast(this.portalDescription()));
            }
            case "portalContactEmail": {
                return Optional.ofNullable(clazz.cast(this.portalContactEmail()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "portalLogoImageFile": {
                return Optional.ofNullable(clazz.cast(this.portalLogoImageFile()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "portalAuthMode": {
                return Optional.ofNullable(clazz.cast(this.portalAuthModeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePortalRequest, T> g) {
        return obj -> g.apply((CreatePortalRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String portalName;
        private String portalDescription;
        private String portalContactEmail;
        private String clientToken;
        private ImageFile portalLogoImageFile;
        private String roleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String portalAuthMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortalRequest model) {
            super(model);
            this.portalName(model.portalName);
            this.portalDescription(model.portalDescription);
            this.portalContactEmail(model.portalContactEmail);
            this.clientToken(model.clientToken);
            this.portalLogoImageFile(model.portalLogoImageFile);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.portalAuthMode(model.portalAuthMode);
        }

        public final String getPortalName() {
            return this.portalName;
        }

        @Override
        public final Builder portalName(String portalName) {
            this.portalName = portalName;
            return this;
        }

        public final void setPortalName(String portalName) {
            this.portalName = portalName;
        }

        public final String getPortalDescription() {
            return this.portalDescription;
        }

        @Override
        public final Builder portalDescription(String portalDescription) {
            this.portalDescription = portalDescription;
            return this;
        }

        public final void setPortalDescription(String portalDescription) {
            this.portalDescription = portalDescription;
        }

        public final String getPortalContactEmail() {
            return this.portalContactEmail;
        }

        @Override
        public final Builder portalContactEmail(String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
            return this;
        }

        public final void setPortalContactEmail(String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final ImageFile.Builder getPortalLogoImageFile() {
            return this.portalLogoImageFile != null ? this.portalLogoImageFile.toBuilder() : null;
        }

        @Override
        public final Builder portalLogoImageFile(ImageFile portalLogoImageFile) {
            this.portalLogoImageFile = portalLogoImageFile;
            return this;
        }

        public final void setPortalLogoImageFile(ImageFile.BuilderImpl portalLogoImageFile) {
            this.portalLogoImageFile = portalLogoImageFile != null ? portalLogoImageFile.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getPortalAuthMode() {
            return this.portalAuthMode;
        }

        @Override
        public final Builder portalAuthMode(String portalAuthMode) {
            this.portalAuthMode = portalAuthMode;
            return this;
        }

        @Override
        public final Builder portalAuthMode(AuthMode portalAuthMode) {
            this.portalAuthMode(portalAuthMode == null ? null : portalAuthMode.toString());
            return this;
        }

        public final void setPortalAuthMode(String portalAuthMode) {
            this.portalAuthMode = portalAuthMode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePortalRequest build() {
            return new CreatePortalRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePortalRequest> {
        public Builder portalName(String var1);

        public Builder portalDescription(String var1);

        public Builder portalContactEmail(String var1);

        public Builder clientToken(String var1);

        public Builder portalLogoImageFile(ImageFile var1);

        default public Builder portalLogoImageFile(Consumer<ImageFile.Builder> portalLogoImageFile) {
            return this.portalLogoImageFile((ImageFile)((ImageFile.Builder)ImageFile.builder().applyMutation(portalLogoImageFile)).build());
        }

        public Builder roleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder portalAuthMode(String var1);

        public Builder portalAuthMode(AuthMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

