/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.Quality;
import software.amazon.awssdk.services.iotsitewise.model.TimeInNanos;
import software.amazon.awssdk.services.iotsitewise.model.Variant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetPropertyValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetPropertyValue> {
    private static final SdkField<Variant> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("value").getter(AssetPropertyValue.getter(AssetPropertyValue::value)).setter(AssetPropertyValue.setter(Builder::value)).constructor(Variant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<TimeInNanos> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timestamp").getter(AssetPropertyValue.getter(AssetPropertyValue::timestamp)).setter(AssetPropertyValue.setter(Builder::timestamp)).constructor(TimeInNanos::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("quality").getter(AssetPropertyValue.getter(AssetPropertyValue::qualityAsString)).setter(AssetPropertyValue.setter(Builder::quality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TIMESTAMP_FIELD, QUALITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Variant value;
    private final TimeInNanos timestamp;
    private final String quality;

    private AssetPropertyValue(BuilderImpl builder) {
        this.value = builder.value;
        this.timestamp = builder.timestamp;
        this.quality = builder.quality;
    }

    public Variant value() {
        return this.value;
    }

    public TimeInNanos timestamp() {
        return this.timestamp;
    }

    public Quality quality() {
        return Quality.fromValue(this.quality);
    }

    public String qualityAsString() {
        return this.quality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetPropertyValue)) {
            return false;
        }
        AssetPropertyValue other = (AssetPropertyValue)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.qualityAsString(), other.qualityAsString());
    }

    public String toString() {
        return ToString.builder((String)"AssetPropertyValue").add("Value", (Object)this.value()).add("Timestamp", (Object)this.timestamp()).add("Quality", (Object)this.qualityAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "quality": {
                return Optional.ofNullable(clazz.cast(this.qualityAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetPropertyValue, T> g) {
        return obj -> g.apply((AssetPropertyValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Variant value;
        private TimeInNanos timestamp;
        private String quality;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetPropertyValue model) {
            this.value(model.value);
            this.timestamp(model.timestamp);
            this.quality(model.quality);
        }

        public final Variant.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        @Override
        public final Builder value(Variant value) {
            this.value = value;
            return this;
        }

        public final void setValue(Variant.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        public final TimeInNanos.Builder getTimestamp() {
            return this.timestamp != null ? this.timestamp.toBuilder() : null;
        }

        @Override
        public final Builder timestamp(TimeInNanos timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(TimeInNanos.BuilderImpl timestamp) {
            this.timestamp = timestamp != null ? timestamp.build() : null;
        }

        public final String getQuality() {
            return this.quality;
        }

        @Override
        public final Builder quality(String quality) {
            this.quality = quality;
            return this;
        }

        @Override
        public final Builder quality(Quality quality) {
            this.quality(quality == null ? null : quality.toString());
            return this;
        }

        public final void setQuality(String quality) {
            this.quality = quality;
        }

        public AssetPropertyValue build() {
            return new AssetPropertyValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetPropertyValue> {
        public Builder value(Variant var1);

        default public Builder value(Consumer<Variant.Builder> value) {
            return this.value((Variant)((Variant.Builder)Variant.builder().applyMutation(value)).build());
        }

        public Builder timestamp(TimeInNanos var1);

        default public Builder timestamp(Consumer<TimeInNanos.Builder> timestamp) {
            return this.timestamp((TimeInNanos)((TimeInNanos.Builder)TimeInNanos.builder().applyMutation(timestamp)).build());
        }

        public Builder quality(String var1);

        public Builder quality(Quality var1);
    }
}

