/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PropertyDataType {
    STRING("STRING"),
    INTEGER("INTEGER"),
    DOUBLE("DOUBLE"),
    BOOLEAN("BOOLEAN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PropertyDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PropertyDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PropertyDataType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PropertyDataType> knownValues() {
        return Stream.of(PropertyDataType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

