/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.services.iotsitewise.model.Property;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssetPropertyResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeAssetPropertyResponse> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(DescribeAssetPropertyResponse.getter(DescribeAssetPropertyResponse::assetId)).setter(DescribeAssetPropertyResponse.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetName").getter(DescribeAssetPropertyResponse.getter(DescribeAssetPropertyResponse::assetName)).setter(DescribeAssetPropertyResponse.setter(Builder::assetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetName").build()}).build();
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(DescribeAssetPropertyResponse.getter(DescribeAssetPropertyResponse::assetModelId)).setter(DescribeAssetPropertyResponse.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()}).build();
    private static final SdkField<Property> ASSET_PROPERTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetProperty").getter(DescribeAssetPropertyResponse.getter(DescribeAssetPropertyResponse::assetProperty)).setter(DescribeAssetPropertyResponse.setter(Builder::assetProperty)).constructor(Property::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetProperty").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, ASSET_NAME_FIELD, ASSET_MODEL_ID_FIELD, ASSET_PROPERTY_FIELD));
    private final String assetId;
    private final String assetName;
    private final String assetModelId;
    private final Property assetProperty;

    private DescribeAssetPropertyResponse(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.assetName = builder.assetName;
        this.assetModelId = builder.assetModelId;
        this.assetProperty = builder.assetProperty;
    }

    public String assetId() {
        return this.assetId;
    }

    public String assetName() {
        return this.assetName;
    }

    public String assetModelId() {
        return this.assetModelId;
    }

    public Property assetProperty() {
        return this.assetProperty;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetProperty());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetPropertyResponse)) {
            return false;
        }
        DescribeAssetPropertyResponse other = (DescribeAssetPropertyResponse)((Object)obj);
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.assetName(), other.assetName()) && Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.assetProperty(), other.assetProperty());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAssetPropertyResponse").add("AssetId", (Object)this.assetId()).add("AssetName", (Object)this.assetName()).add("AssetModelId", (Object)this.assetModelId()).add("AssetProperty", (Object)this.assetProperty()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "assetName": {
                return Optional.ofNullable(clazz.cast(this.assetName()));
            }
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "assetProperty": {
                return Optional.ofNullable(clazz.cast(this.assetProperty()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetPropertyResponse, T> g) {
        return obj -> g.apply((DescribeAssetPropertyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String assetId;
        private String assetName;
        private String assetModelId;
        private Property assetProperty;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetPropertyResponse model) {
            super(model);
            this.assetId(model.assetId);
            this.assetName(model.assetName);
            this.assetModelId(model.assetModelId);
            this.assetProperty(model.assetProperty);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        public final String getAssetName() {
            return this.assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        public final Property.Builder getAssetProperty() {
            return this.assetProperty != null ? this.assetProperty.toBuilder() : null;
        }

        @Override
        public final Builder assetProperty(Property assetProperty) {
            this.assetProperty = assetProperty;
            return this;
        }

        public final void setAssetProperty(Property.BuilderImpl assetProperty) {
            this.assetProperty = assetProperty != null ? assetProperty.build() : null;
        }

        @Override
        public DescribeAssetPropertyResponse build() {
            return new DescribeAssetPropertyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssetPropertyResponse> {
        public Builder assetId(String var1);

        public Builder assetName(String var1);

        public Builder assetModelId(String var1);

        public Builder assetProperty(Property var1);

        default public Builder assetProperty(Consumer<Property.Builder> assetProperty) {
            return this.assetProperty((Property)((Property.Builder)Property.builder().applyMutation(assetProperty)).build());
        }
    }
}

