/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGatewayCapabilityConfigurationRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, DescribeGatewayCapabilityConfigurationRequest> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayId").getter(DescribeGatewayCapabilityConfigurationRequest.getter(DescribeGatewayCapabilityConfigurationRequest::gatewayId)).setter(DescribeGatewayCapabilityConfigurationRequest.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayId").build()}).build();
    private static final SdkField<String> CAPABILITY_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capabilityNamespace").getter(DescribeGatewayCapabilityConfigurationRequest.getter(DescribeGatewayCapabilityConfigurationRequest::capabilityNamespace)).setter(DescribeGatewayCapabilityConfigurationRequest.setter(Builder::capabilityNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("capabilityNamespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD, CAPABILITY_NAMESPACE_FIELD));
    private final String gatewayId;
    private final String capabilityNamespace;

    private DescribeGatewayCapabilityConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.capabilityNamespace = builder.capabilityNamespace;
    }

    public String gatewayId() {
        return this.gatewayId;
    }

    public String capabilityNamespace() {
        return this.capabilityNamespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityNamespace());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGatewayCapabilityConfigurationRequest)) {
            return false;
        }
        DescribeGatewayCapabilityConfigurationRequest other = (DescribeGatewayCapabilityConfigurationRequest)((Object)obj);
        return Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.capabilityNamespace(), other.capabilityNamespace());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGatewayCapabilityConfigurationRequest").add("GatewayId", (Object)this.gatewayId()).add("CapabilityNamespace", (Object)this.capabilityNamespace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "capabilityNamespace": {
                return Optional.ofNullable(clazz.cast(this.capabilityNamespace()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGatewayCapabilityConfigurationRequest, T> g) {
        return obj -> g.apply((DescribeGatewayCapabilityConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String gatewayId;
        private String capabilityNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGatewayCapabilityConfigurationRequest model) {
            super(model);
            this.gatewayId(model.gatewayId);
            this.capabilityNamespace(model.capabilityNamespace);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getCapabilityNamespace() {
            return this.capabilityNamespace;
        }

        @Override
        public final Builder capabilityNamespace(String capabilityNamespace) {
            this.capabilityNamespace = capabilityNamespace;
            return this;
        }

        public final void setCapabilityNamespace(String capabilityNamespace) {
            this.capabilityNamespace = capabilityNamespace;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeGatewayCapabilityConfigurationRequest build() {
            return new DescribeGatewayCapabilityConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGatewayCapabilityConfigurationRequest> {
        public Builder gatewayId(String var1);

        public Builder capabilityNamespace(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

