/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.Image;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePortalRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, UpdatePortalRequest> {
    private static final SdkField<String> PORTAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalId").getter(UpdatePortalRequest.getter(UpdatePortalRequest::portalId)).setter(UpdatePortalRequest.setter(Builder::portalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("portalId").build()}).build();
    private static final SdkField<String> PORTAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalName").getter(UpdatePortalRequest.getter(UpdatePortalRequest::portalName)).setter(UpdatePortalRequest.setter(Builder::portalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalName").build()}).build();
    private static final SdkField<String> PORTAL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalDescription").getter(UpdatePortalRequest.getter(UpdatePortalRequest::portalDescription)).setter(UpdatePortalRequest.setter(Builder::portalDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalDescription").build()}).build();
    private static final SdkField<String> PORTAL_CONTACT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalContactEmail").getter(UpdatePortalRequest.getter(UpdatePortalRequest::portalContactEmail)).setter(UpdatePortalRequest.setter(Builder::portalContactEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalContactEmail").build()}).build();
    private static final SdkField<Image> PORTAL_LOGO_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("portalLogoImage").getter(UpdatePortalRequest.getter(UpdatePortalRequest::portalLogoImage)).setter(UpdatePortalRequest.setter(Builder::portalLogoImage)).constructor(Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalLogoImage").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdatePortalRequest.getter(UpdatePortalRequest::roleArn)).setter(UpdatePortalRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdatePortalRequest.getter(UpdatePortalRequest::clientToken)).setter(UpdatePortalRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_ID_FIELD, PORTAL_NAME_FIELD, PORTAL_DESCRIPTION_FIELD, PORTAL_CONTACT_EMAIL_FIELD, PORTAL_LOGO_IMAGE_FIELD, ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD));
    private final String portalId;
    private final String portalName;
    private final String portalDescription;
    private final String portalContactEmail;
    private final Image portalLogoImage;
    private final String roleArn;
    private final String clientToken;

    private UpdatePortalRequest(BuilderImpl builder) {
        super(builder);
        this.portalId = builder.portalId;
        this.portalName = builder.portalName;
        this.portalDescription = builder.portalDescription;
        this.portalContactEmail = builder.portalContactEmail;
        this.portalLogoImage = builder.portalLogoImage;
        this.roleArn = builder.roleArn;
        this.clientToken = builder.clientToken;
    }

    public String portalId() {
        return this.portalId;
    }

    public String portalName() {
        return this.portalName;
    }

    public String portalDescription() {
        return this.portalDescription;
    }

    public String portalContactEmail() {
        return this.portalContactEmail;
    }

    public Image portalLogoImage() {
        return this.portalLogoImage;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.portalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalContactEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalLogoImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePortalRequest)) {
            return false;
        }
        UpdatePortalRequest other = (UpdatePortalRequest)((Object)obj);
        return Objects.equals(this.portalId(), other.portalId()) && Objects.equals(this.portalName(), other.portalName()) && Objects.equals(this.portalDescription(), other.portalDescription()) && Objects.equals(this.portalContactEmail(), other.portalContactEmail()) && Objects.equals(this.portalLogoImage(), other.portalLogoImage()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"UpdatePortalRequest").add("PortalId", (Object)this.portalId()).add("PortalName", (Object)this.portalName()).add("PortalDescription", (Object)this.portalDescription()).add("PortalContactEmail", (Object)this.portalContactEmail()).add("PortalLogoImage", (Object)this.portalLogoImage()).add("RoleArn", (Object)this.roleArn()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portalId": {
                return Optional.ofNullable(clazz.cast(this.portalId()));
            }
            case "portalName": {
                return Optional.ofNullable(clazz.cast(this.portalName()));
            }
            case "portalDescription": {
                return Optional.ofNullable(clazz.cast(this.portalDescription()));
            }
            case "portalContactEmail": {
                return Optional.ofNullable(clazz.cast(this.portalContactEmail()));
            }
            case "portalLogoImage": {
                return Optional.ofNullable(clazz.cast(this.portalLogoImage()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePortalRequest, T> g) {
        return obj -> g.apply((UpdatePortalRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String portalId;
        private String portalName;
        private String portalDescription;
        private String portalContactEmail;
        private Image portalLogoImage;
        private String roleArn;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePortalRequest model) {
            super(model);
            this.portalId(model.portalId);
            this.portalName(model.portalName);
            this.portalDescription(model.portalDescription);
            this.portalContactEmail(model.portalContactEmail);
            this.portalLogoImage(model.portalLogoImage);
            this.roleArn(model.roleArn);
            this.clientToken(model.clientToken);
        }

        public final String getPortalId() {
            return this.portalId;
        }

        @Override
        public final Builder portalId(String portalId) {
            this.portalId = portalId;
            return this;
        }

        public final void setPortalId(String portalId) {
            this.portalId = portalId;
        }

        public final String getPortalName() {
            return this.portalName;
        }

        @Override
        public final Builder portalName(String portalName) {
            this.portalName = portalName;
            return this;
        }

        public final void setPortalName(String portalName) {
            this.portalName = portalName;
        }

        public final String getPortalDescription() {
            return this.portalDescription;
        }

        @Override
        public final Builder portalDescription(String portalDescription) {
            this.portalDescription = portalDescription;
            return this;
        }

        public final void setPortalDescription(String portalDescription) {
            this.portalDescription = portalDescription;
        }

        public final String getPortalContactEmail() {
            return this.portalContactEmail;
        }

        @Override
        public final Builder portalContactEmail(String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
            return this;
        }

        public final void setPortalContactEmail(String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
        }

        public final Image.Builder getPortalLogoImage() {
            return this.portalLogoImage != null ? this.portalLogoImage.toBuilder() : null;
        }

        @Override
        public final Builder portalLogoImage(Image portalLogoImage) {
            this.portalLogoImage = portalLogoImage;
            return this;
        }

        public final void setPortalLogoImage(Image.BuilderImpl portalLogoImage) {
            this.portalLogoImage = portalLogoImage != null ? portalLogoImage.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePortalRequest build() {
            return new UpdatePortalRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePortalRequest> {
        public Builder portalId(String var1);

        public Builder portalName(String var1);

        public Builder portalDescription(String var1);

        public Builder portalContactEmail(String var1);

        public Builder portalLogoImage(Image var1);

        default public Builder portalLogoImage(Consumer<Image.Builder> portalLogoImage) {
            return this.portalLogoImage((Image)((Image.Builder)Image.builder().applyMutation(portalLogoImage)).build());
        }

        public Builder roleArn(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

