/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGatewayCapabilityConfigurationResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeGatewayCapabilityConfigurationResponse> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayId").getter(DescribeGatewayCapabilityConfigurationResponse.getter(DescribeGatewayCapabilityConfigurationResponse::gatewayId)).setter(DescribeGatewayCapabilityConfigurationResponse.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()}).build();
    private static final SdkField<String> CAPABILITY_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capabilityNamespace").getter(DescribeGatewayCapabilityConfigurationResponse.getter(DescribeGatewayCapabilityConfigurationResponse::capabilityNamespace)).setter(DescribeGatewayCapabilityConfigurationResponse.setter(Builder::capabilityNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityNamespace").build()}).build();
    private static final SdkField<String> CAPABILITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capabilityConfiguration").getter(DescribeGatewayCapabilityConfigurationResponse.getter(DescribeGatewayCapabilityConfigurationResponse::capabilityConfiguration)).setter(DescribeGatewayCapabilityConfigurationResponse.setter(Builder::capabilityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityConfiguration").build()}).build();
    private static final SdkField<String> CAPABILITY_SYNC_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capabilitySyncStatus").getter(DescribeGatewayCapabilityConfigurationResponse.getter(DescribeGatewayCapabilityConfigurationResponse::capabilitySyncStatusAsString)).setter(DescribeGatewayCapabilityConfigurationResponse.setter(Builder::capabilitySyncStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilitySyncStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD, CAPABILITY_NAMESPACE_FIELD, CAPABILITY_CONFIGURATION_FIELD, CAPABILITY_SYNC_STATUS_FIELD));
    private final String gatewayId;
    private final String capabilityNamespace;
    private final String capabilityConfiguration;
    private final String capabilitySyncStatus;

    private DescribeGatewayCapabilityConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.capabilityNamespace = builder.capabilityNamespace;
        this.capabilityConfiguration = builder.capabilityConfiguration;
        this.capabilitySyncStatus = builder.capabilitySyncStatus;
    }

    public String gatewayId() {
        return this.gatewayId;
    }

    public String capabilityNamespace() {
        return this.capabilityNamespace;
    }

    public String capabilityConfiguration() {
        return this.capabilityConfiguration;
    }

    public CapabilitySyncStatus capabilitySyncStatus() {
        return CapabilitySyncStatus.fromValue(this.capabilitySyncStatus);
    }

    public String capabilitySyncStatusAsString() {
        return this.capabilitySyncStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilitySyncStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGatewayCapabilityConfigurationResponse)) {
            return false;
        }
        DescribeGatewayCapabilityConfigurationResponse other = (DescribeGatewayCapabilityConfigurationResponse)((Object)obj);
        return Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.capabilityNamespace(), other.capabilityNamespace()) && Objects.equals(this.capabilityConfiguration(), other.capabilityConfiguration()) && Objects.equals(this.capabilitySyncStatusAsString(), other.capabilitySyncStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGatewayCapabilityConfigurationResponse").add("GatewayId", (Object)this.gatewayId()).add("CapabilityNamespace", (Object)this.capabilityNamespace()).add("CapabilityConfiguration", (Object)this.capabilityConfiguration()).add("CapabilitySyncStatus", (Object)this.capabilitySyncStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "capabilityNamespace": {
                return Optional.ofNullable(clazz.cast(this.capabilityNamespace()));
            }
            case "capabilityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.capabilityConfiguration()));
            }
            case "capabilitySyncStatus": {
                return Optional.ofNullable(clazz.cast(this.capabilitySyncStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGatewayCapabilityConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeGatewayCapabilityConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String gatewayId;
        private String capabilityNamespace;
        private String capabilityConfiguration;
        private String capabilitySyncStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGatewayCapabilityConfigurationResponse model) {
            super(model);
            this.gatewayId(model.gatewayId);
            this.capabilityNamespace(model.capabilityNamespace);
            this.capabilityConfiguration(model.capabilityConfiguration);
            this.capabilitySyncStatus(model.capabilitySyncStatus);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getCapabilityNamespace() {
            return this.capabilityNamespace;
        }

        @Override
        public final Builder capabilityNamespace(String capabilityNamespace) {
            this.capabilityNamespace = capabilityNamespace;
            return this;
        }

        public final void setCapabilityNamespace(String capabilityNamespace) {
            this.capabilityNamespace = capabilityNamespace;
        }

        public final String getCapabilityConfiguration() {
            return this.capabilityConfiguration;
        }

        @Override
        public final Builder capabilityConfiguration(String capabilityConfiguration) {
            this.capabilityConfiguration = capabilityConfiguration;
            return this;
        }

        public final void setCapabilityConfiguration(String capabilityConfiguration) {
            this.capabilityConfiguration = capabilityConfiguration;
        }

        public final String getCapabilitySyncStatus() {
            return this.capabilitySyncStatus;
        }

        @Override
        public final Builder capabilitySyncStatus(String capabilitySyncStatus) {
            this.capabilitySyncStatus = capabilitySyncStatus;
            return this;
        }

        @Override
        public final Builder capabilitySyncStatus(CapabilitySyncStatus capabilitySyncStatus) {
            this.capabilitySyncStatus(capabilitySyncStatus == null ? null : capabilitySyncStatus.toString());
            return this;
        }

        public final void setCapabilitySyncStatus(String capabilitySyncStatus) {
            this.capabilitySyncStatus = capabilitySyncStatus;
        }

        @Override
        public DescribeGatewayCapabilityConfigurationResponse build() {
            return new DescribeGatewayCapabilityConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGatewayCapabilityConfigurationResponse> {
        public Builder gatewayId(String var1);

        public Builder capabilityNamespace(String var1);

        public Builder capabilityConfiguration(String var1);

        public Builder capabilitySyncStatus(String var1);

        public Builder capabilitySyncStatus(CapabilitySyncStatus var1);
    }
}

