/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotsitewise.model.GatewayPlatform;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGatewayRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, CreateGatewayRequest> {
    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGatewayRequest.getter(CreateGatewayRequest::gatewayName)).setter(CreateGatewayRequest.setter(Builder::gatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayName").build()}).build();
    private static final SdkField<GatewayPlatform> GATEWAY_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateGatewayRequest.getter(CreateGatewayRequest::gatewayPlatform)).setter(CreateGatewayRequest.setter(Builder::gatewayPlatform)).constructor(GatewayPlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayPlatform").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateGatewayRequest.getter(CreateGatewayRequest::tags)).setter(CreateGatewayRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_NAME_FIELD, GATEWAY_PLATFORM_FIELD, TAGS_FIELD));
    private final String gatewayName;
    private final GatewayPlatform gatewayPlatform;
    private final Map<String, String> tags;

    private CreateGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayName = builder.gatewayName;
        this.gatewayPlatform = builder.gatewayPlatform;
        this.tags = builder.tags;
    }

    public String gatewayName() {
        return this.gatewayName;
    }

    public GatewayPlatform gatewayPlatform() {
        return this.gatewayPlatform;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayPlatform());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGatewayRequest)) {
            return false;
        }
        CreateGatewayRequest other = (CreateGatewayRequest)((Object)obj);
        return Objects.equals(this.gatewayName(), other.gatewayName()) && Objects.equals(this.gatewayPlatform(), other.gatewayPlatform()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateGatewayRequest").add("GatewayName", (Object)this.gatewayName()).add("GatewayPlatform", (Object)this.gatewayPlatform()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayName": {
                return Optional.ofNullable(clazz.cast(this.gatewayName()));
            }
            case "gatewayPlatform": {
                return Optional.ofNullable(clazz.cast(this.gatewayPlatform()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGatewayRequest, T> g) {
        return obj -> g.apply((CreateGatewayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String gatewayName;
        private GatewayPlatform gatewayPlatform;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGatewayRequest model) {
            super(model);
            this.gatewayName(model.gatewayName);
            this.gatewayPlatform(model.gatewayPlatform);
            this.tags(model.tags);
        }

        public final String getGatewayName() {
            return this.gatewayName;
        }

        @Override
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        public final GatewayPlatform.Builder getGatewayPlatform() {
            return this.gatewayPlatform != null ? this.gatewayPlatform.toBuilder() : null;
        }

        @Override
        public final Builder gatewayPlatform(GatewayPlatform gatewayPlatform) {
            this.gatewayPlatform = gatewayPlatform;
            return this;
        }

        public final void setGatewayPlatform(GatewayPlatform.BuilderImpl gatewayPlatform) {
            this.gatewayPlatform = gatewayPlatform != null ? gatewayPlatform.build() : null;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGatewayRequest build() {
            return new CreateGatewayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGatewayRequest> {
        public Builder gatewayName(String var1);

        public Builder gatewayPlatform(GatewayPlatform var1);

        default public Builder gatewayPlatform(Consumer<GatewayPlatform.Builder> gatewayPlatform) {
            return this.gatewayPlatform((GatewayPlatform)((GatewayPlatform.Builder)GatewayPlatform.builder().applyMutation(gatewayPlatform)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

