/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an asset property value (of a single type only).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Variant implements SdkPojo, Serializable, ToCopyableBuilder<Variant.Builder, Variant> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Variant::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final SdkField<Integer> INTEGER_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Variant::integerValue)).setter(setter(Builder::integerValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValue").build()).build();

    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Variant::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()).build();

    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Variant::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD,
            INTEGER_VALUE_FIELD, DOUBLE_VALUE_FIELD, BOOLEAN_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stringValue;

    private final Integer integerValue;

    private final Double doubleValue;

    private final Boolean booleanValue;

    private Variant(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.integerValue = builder.integerValue;
        this.doubleValue = builder.doubleValue;
        this.booleanValue = builder.booleanValue;
    }

    /**
     * <p>
     * Asset property data of type string (sequence of characters).
     * </p>
     * 
     * @return Asset property data of type string (sequence of characters).
     */
    public String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * Asset property data of type integer (whole number).
     * </p>
     * 
     * @return Asset property data of type integer (whole number).
     */
    public Integer integerValue() {
        return integerValue;
    }

    /**
     * <p>
     * Asset property data of type double (floating point number).
     * </p>
     * 
     * @return Asset property data of type double (floating point number).
     */
    public Double doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * Asset property data of type Boolean (true or false).
     * </p>
     * 
     * @return Asset property data of type Boolean (true or false).
     */
    public Boolean booleanValue() {
        return booleanValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Variant)) {
            return false;
        }
        Variant other = (Variant) obj;
        return Objects.equals(stringValue(), other.stringValue()) && Objects.equals(integerValue(), other.integerValue())
                && Objects.equals(doubleValue(), other.doubleValue()) && Objects.equals(booleanValue(), other.booleanValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Variant").add("StringValue", stringValue()).add("IntegerValue", integerValue())
                .add("DoubleValue", doubleValue()).add("BooleanValue", booleanValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "integerValue":
            return Optional.ofNullable(clazz.cast(integerValue()));
        case "doubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "booleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Variant, T> g) {
        return obj -> g.apply((Variant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Variant> {
        /**
         * <p>
         * Asset property data of type string (sequence of characters).
         * </p>
         * 
         * @param stringValue
         *        Asset property data of type string (sequence of characters).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * Asset property data of type integer (whole number).
         * </p>
         * 
         * @param integerValue
         *        Asset property data of type integer (whole number).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerValue(Integer integerValue);

        /**
         * <p>
         * Asset property data of type double (floating point number).
         * </p>
         * 
         * @param doubleValue
         *        Asset property data of type double (floating point number).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * <p>
         * Asset property data of type Boolean (true or false).
         * </p>
         * 
         * @param booleanValue
         *        Asset property data of type Boolean (true or false).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);
    }

    static final class BuilderImpl implements Builder {
        private String stringValue;

        private Integer integerValue;

        private Double doubleValue;

        private Boolean booleanValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Variant model) {
            stringValue(model.stringValue);
            integerValue(model.integerValue);
            doubleValue(model.doubleValue);
            booleanValue(model.booleanValue);
        }

        public final String getStringValue() {
            return stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final Integer getIntegerValue() {
            return integerValue;
        }

        @Override
        public final Builder integerValue(Integer integerValue) {
            this.integerValue = integerValue;
            return this;
        }

        public final void setIntegerValue(Integer integerValue) {
            this.integerValue = integerValue;
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        @Override
        public Variant build() {
            return new Variant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
