/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a tumbling window, which is a repeating fixed-sized, non-overlapping, and contiguous time interval. This
 * window is used in metric and aggregation computations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TumblingWindow implements SdkPojo, Serializable, ToCopyableBuilder<TumblingWindow.Builder, TumblingWindow> {
    private static final SdkField<String> INTERVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TumblingWindow::interval)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interval").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String interval;

    private TumblingWindow(BuilderImpl builder) {
        this.interval = builder.interval;
    }

    /**
     * <p>
     * The time interval for the tumbling window. Note that <code>w</code> represents weeks, <code>d</code> represents
     * days, <code>h</code> represents hours, and <code>m</code> represents minutes. AWS IoT SiteWise computes the
     * <code>1w</code> interval the end of Sunday at midnight each week (UTC), the <code>1d</code> interval at the end
     * of each day at midnight (UTC), the <code>1h</code> interval at the end of each hour, and so on.
     * </p>
     * <p>
     * When AWS IoT SiteWise aggregates data points for metric computations, the start of each interval is exclusive and
     * the end of each interval is inclusive. AWS IoT SiteWise places the computed data point at the end of the
     * interval.
     * </p>
     * 
     * @return The time interval for the tumbling window. Note that <code>w</code> represents weeks, <code>d</code>
     *         represents days, <code>h</code> represents hours, and <code>m</code> represents minutes. AWS IoT SiteWise
     *         computes the <code>1w</code> interval the end of Sunday at midnight each week (UTC), the <code>1d</code>
     *         interval at the end of each day at midnight (UTC), the <code>1h</code> interval at the end of each hour,
     *         and so on. </p>
     *         <p>
     *         When AWS IoT SiteWise aggregates data points for metric computations, the start of each interval is
     *         exclusive and the end of each interval is inclusive. AWS IoT SiteWise places the computed data point at
     *         the end of the interval.
     */
    public String interval() {
        return interval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TumblingWindow)) {
            return false;
        }
        TumblingWindow other = (TumblingWindow) obj;
        return Objects.equals(interval(), other.interval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TumblingWindow").add("Interval", interval()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "interval":
            return Optional.ofNullable(clazz.cast(interval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TumblingWindow, T> g) {
        return obj -> g.apply((TumblingWindow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TumblingWindow> {
        /**
         * <p>
         * The time interval for the tumbling window. Note that <code>w</code> represents weeks, <code>d</code>
         * represents days, <code>h</code> represents hours, and <code>m</code> represents minutes. AWS IoT SiteWise
         * computes the <code>1w</code> interval the end of Sunday at midnight each week (UTC), the <code>1d</code>
         * interval at the end of each day at midnight (UTC), the <code>1h</code> interval at the end of each hour, and
         * so on.
         * </p>
         * <p>
         * When AWS IoT SiteWise aggregates data points for metric computations, the start of each interval is exclusive
         * and the end of each interval is inclusive. AWS IoT SiteWise places the computed data point at the end of the
         * interval.
         * </p>
         * 
         * @param interval
         *        The time interval for the tumbling window. Note that <code>w</code> represents weeks, <code>d</code>
         *        represents days, <code>h</code> represents hours, and <code>m</code> represents minutes. AWS IoT
         *        SiteWise computes the <code>1w</code> interval the end of Sunday at midnight each week (UTC), the
         *        <code>1d</code> interval at the end of each day at midnight (UTC), the <code>1h</code> interval at the
         *        end of each hour, and so on. </p>
         *        <p>
         *        When AWS IoT SiteWise aggregates data points for metric computations, the start of each interval is
         *        exclusive and the end of each interval is inclusive. AWS IoT SiteWise places the computed data point
         *        at the end of the interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(String interval);
    }

    static final class BuilderImpl implements Builder {
        private String interval;

        private BuilderImpl() {
        }

        private BuilderImpl(TumblingWindow model) {
            interval(model.interval);
        }

        public final String getInterval() {
            return interval;
        }

        @Override
        public final Builder interval(String interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(String interval) {
            this.interval = interval;
        }

        @Override
        public TumblingWindow build() {
            return new TumblingWindow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
