/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an image that is one of the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * An image file. Choose this option to upload a new image.
 * </p>
 * </li>
 * <li>
 * <p>
 * The ID of an existing image. Choose this option to keep an existing image.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Image implements SdkPojo, Serializable, ToCopyableBuilder<Image.Builder, Image> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(Image::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<ImageFile> FILE_FIELD = SdkField.<ImageFile> builder(MarshallingType.SDK_POJO)
            .getter(getter(Image::file)).setter(setter(Builder::file)).constructor(ImageFile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, FILE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final ImageFile file;

    private Image(BuilderImpl builder) {
        this.id = builder.id;
        this.file = builder.file;
    }

    /**
     * <p>
     * The ID of an existing image. Specify this parameter to keep an existing image.
     * </p>
     * 
     * @return The ID of an existing image. Specify this parameter to keep an existing image.
     */
    public String id() {
        return id;
    }

    /**
     * Returns the value of the File property for this object.
     * 
     * @return The value of the File property for this object.
     */
    public ImageFile file() {
        return file;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(file());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(file(), other.file());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Image").add("Id", id()).add("File", file()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Image> {
        /**
         * <p>
         * The ID of an existing image. Specify this parameter to keep an existing image.
         * </p>
         * 
         * @param id
         *        The ID of an existing image. Specify this parameter to keep an existing image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the File property for this object.
         *
         * @param file
         *        The new value for the File property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(ImageFile file);

        /**
         * Sets the value of the File property for this object.
         *
         * This is a convenience that creates an instance of the {@link ImageFile.Builder} avoiding the need to create
         * one manually via {@link ImageFile#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageFile.Builder#build()} is called immediately and its result
         * is passed to {@link #file(ImageFile)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link ImageFile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(ImageFile)
         */
        default Builder file(Consumer<ImageFile.Builder> file) {
            return file(ImageFile.builder().applyMutation(file).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private ImageFile file;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            id(model.id);
            file(model.file);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final ImageFile.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        @Override
        public final Builder file(ImageFile file) {
            this.file = file;
            return this;
        }

        public final void setFile(ImageFile.BuilderImpl file) {
            this.file = file != null ? file.build() : null;
        }

        @Override
        public Image build() {
            return new Image(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
