/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGatewayCapabilityConfigurationResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeGatewayCapabilityConfigurationResponse.Builder, DescribeGatewayCapabilityConfigurationResponse> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayCapabilityConfigurationResponse::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()).build();

    private static final SdkField<String> CAPABILITY_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayCapabilityConfigurationResponse::capabilityNamespace))
            .setter(setter(Builder::capabilityNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityNamespace").build())
            .build();

    private static final SdkField<String> CAPABILITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayCapabilityConfigurationResponse::capabilityConfiguration))
            .setter(setter(Builder::capabilityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityConfiguration").build())
            .build();

    private static final SdkField<String> CAPABILITY_SYNC_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayCapabilityConfigurationResponse::capabilitySyncStatusAsString))
            .setter(setter(Builder::capabilitySyncStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilitySyncStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            CAPABILITY_NAMESPACE_FIELD, CAPABILITY_CONFIGURATION_FIELD, CAPABILITY_SYNC_STATUS_FIELD));

    private final String gatewayId;

    private final String capabilityNamespace;

    private final String capabilityConfiguration;

    private final String capabilitySyncStatus;

    private DescribeGatewayCapabilityConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.capabilityNamespace = builder.capabilityNamespace;
        this.capabilityConfiguration = builder.capabilityConfiguration;
        this.capabilitySyncStatus = builder.capabilitySyncStatus;
    }

    /**
     * <p>
     * The ID of the gateway that defines the capability configuration.
     * </p>
     * 
     * @return The ID of the gateway that defines the capability configuration.
     */
    public String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The namespace of the gateway capability.
     * </p>
     * 
     * @return The namespace of the gateway capability.
     */
    public String capabilityNamespace() {
        return capabilityNamespace;
    }

    /**
     * <p>
     * The JSON document that defines the gateway capability's configuration. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli"
     * >Configuring data sources (CLI)</a> in the <i>AWS IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The JSON document that defines the gateway capability's configuration. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli"
     *         >Configuring data sources (CLI)</a> in the <i>AWS IoT SiteWise User Guide</i>.
     */
    public String capabilityConfiguration() {
        return capabilityConfiguration;
    }

    /**
     * <p>
     * The synchronization status of the capability configuration. The sync status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_SYNC</code> – The gateway is running the capability configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capabilitySyncStatus} will return {@link CapabilitySyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #capabilitySyncStatusAsString}.
     * </p>
     * 
     * @return The synchronization status of the capability configuration. The sync status can be one of the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_SYNC</code> – The gateway is running the capability configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
     *         </p>
     *         </li>
     * @see CapabilitySyncStatus
     */
    public CapabilitySyncStatus capabilitySyncStatus() {
        return CapabilitySyncStatus.fromValue(capabilitySyncStatus);
    }

    /**
     * <p>
     * The synchronization status of the capability configuration. The sync status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_SYNC</code> – The gateway is running the capability configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capabilitySyncStatus} will return {@link CapabilitySyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #capabilitySyncStatusAsString}.
     * </p>
     * 
     * @return The synchronization status of the capability configuration. The sync status can be one of the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_SYNC</code> – The gateway is running the capability configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
     *         </p>
     *         </li>
     * @see CapabilitySyncStatus
     */
    public String capabilitySyncStatusAsString() {
        return capabilitySyncStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(capabilityNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(capabilityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(capabilitySyncStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGatewayCapabilityConfigurationResponse)) {
            return false;
        }
        DescribeGatewayCapabilityConfigurationResponse other = (DescribeGatewayCapabilityConfigurationResponse) obj;
        return Objects.equals(gatewayId(), other.gatewayId())
                && Objects.equals(capabilityNamespace(), other.capabilityNamespace())
                && Objects.equals(capabilityConfiguration(), other.capabilityConfiguration())
                && Objects.equals(capabilitySyncStatusAsString(), other.capabilitySyncStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeGatewayCapabilityConfigurationResponse").add("GatewayId", gatewayId())
                .add("CapabilityNamespace", capabilityNamespace()).add("CapabilityConfiguration", capabilityConfiguration())
                .add("CapabilitySyncStatus", capabilitySyncStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "capabilityNamespace":
            return Optional.ofNullable(clazz.cast(capabilityNamespace()));
        case "capabilityConfiguration":
            return Optional.ofNullable(clazz.cast(capabilityConfiguration()));
        case "capabilitySyncStatus":
            return Optional.ofNullable(clazz.cast(capabilitySyncStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGatewayCapabilityConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeGatewayCapabilityConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeGatewayCapabilityConfigurationResponse> {
        /**
         * <p>
         * The ID of the gateway that defines the capability configuration.
         * </p>
         * 
         * @param gatewayId
         *        The ID of the gateway that defines the capability configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The namespace of the gateway capability.
         * </p>
         * 
         * @param capabilityNamespace
         *        The namespace of the gateway capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityNamespace(String capabilityNamespace);

        /**
         * <p>
         * The JSON document that defines the gateway capability's configuration. For more information, see <a href=
         * "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli"
         * >Configuring data sources (CLI)</a> in the <i>AWS IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param capabilityConfiguration
         *        The JSON document that defines the gateway capability's configuration. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli"
         *        >Configuring data sources (CLI)</a> in the <i>AWS IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityConfiguration(String capabilityConfiguration);

        /**
         * <p>
         * The synchronization status of the capability configuration. The sync status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_SYNC</code> – The gateway is running the capability configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capabilitySyncStatus
         *        The synchronization status of the capability configuration. The sync status can be one of the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code> – The gateway is running the capability configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
         *        </p>
         *        </li>
         * @see CapabilitySyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilitySyncStatus
         */
        Builder capabilitySyncStatus(String capabilitySyncStatus);

        /**
         * <p>
         * The synchronization status of the capability configuration. The sync status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_SYNC</code> – The gateway is running the capability configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capabilitySyncStatus
         *        The synchronization status of the capability configuration. The sync status can be one of the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code> – The gateway is running the capability configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
         *        </p>
         *        </li>
         * @see CapabilitySyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilitySyncStatus
         */
        Builder capabilitySyncStatus(CapabilitySyncStatus capabilitySyncStatus);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String gatewayId;

        private String capabilityNamespace;

        private String capabilityConfiguration;

        private String capabilitySyncStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGatewayCapabilityConfigurationResponse model) {
            super(model);
            gatewayId(model.gatewayId);
            capabilityNamespace(model.capabilityNamespace);
            capabilityConfiguration(model.capabilityConfiguration);
            capabilitySyncStatus(model.capabilitySyncStatus);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getCapabilityNamespace() {
            return capabilityNamespace;
        }

        @Override
        public final Builder capabilityNamespace(String capabilityNamespace) {
            this.capabilityNamespace = capabilityNamespace;
            return this;
        }

        public final void setCapabilityNamespace(String capabilityNamespace) {
            this.capabilityNamespace = capabilityNamespace;
        }

        public final String getCapabilityConfiguration() {
            return capabilityConfiguration;
        }

        @Override
        public final Builder capabilityConfiguration(String capabilityConfiguration) {
            this.capabilityConfiguration = capabilityConfiguration;
            return this;
        }

        public final void setCapabilityConfiguration(String capabilityConfiguration) {
            this.capabilityConfiguration = capabilityConfiguration;
        }

        public final String getCapabilitySyncStatus() {
            return capabilitySyncStatus;
        }

        @Override
        public final Builder capabilitySyncStatus(String capabilitySyncStatus) {
            this.capabilitySyncStatus = capabilitySyncStatus;
            return this;
        }

        @Override
        public final Builder capabilitySyncStatus(CapabilitySyncStatus capabilitySyncStatus) {
            this.capabilitySyncStatus(capabilitySyncStatus == null ? null : capabilitySyncStatus.toString());
            return this;
        }

        public final void setCapabilitySyncStatus(String capabilitySyncStatus) {
            this.capabilitySyncStatus = capabilitySyncStatus;
        }

        @Override
        public DescribeGatewayCapabilityConfigurationResponse build() {
            return new DescribeGatewayCapabilityConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
