/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssetResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeAssetResponse.Builder, DescribeAssetResponse> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAssetResponse::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> ASSET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAssetResponse::assetArn)).setter(setter(Builder::assetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetArn").build()).build();

    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAssetResponse::assetName)).setter(setter(Builder::assetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetName").build()).build();

    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAssetResponse::assetModelId)).setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()).build();

    private static final SdkField<List<AssetProperty>> ASSET_PROPERTIES_FIELD = SdkField
            .<List<AssetProperty>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAssetResponse::assetProperties))
            .setter(setter(Builder::assetProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetHierarchy>> ASSET_HIERARCHIES_FIELD = SdkField
            .<List<AssetHierarchy>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAssetResponse::assetHierarchies))
            .setter(setter(Builder::assetHierarchies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetHierarchies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetHierarchy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetHierarchy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> ASSET_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeAssetResponse::assetCreationDate)).setter(setter(Builder::assetCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCreationDate").build()).build();

    private static final SdkField<Instant> ASSET_LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeAssetResponse::assetLastUpdateDate)).setter(setter(Builder::assetLastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetLastUpdateDate").build())
            .build();

    private static final SdkField<AssetStatus> ASSET_STATUS_FIELD = SdkField.<AssetStatus> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeAssetResponse::assetStatus)).setter(setter(Builder::assetStatus))
            .constructor(AssetStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            ASSET_ARN_FIELD, ASSET_NAME_FIELD, ASSET_MODEL_ID_FIELD, ASSET_PROPERTIES_FIELD, ASSET_HIERARCHIES_FIELD,
            ASSET_CREATION_DATE_FIELD, ASSET_LAST_UPDATE_DATE_FIELD, ASSET_STATUS_FIELD));

    private final String assetId;

    private final String assetArn;

    private final String assetName;

    private final String assetModelId;

    private final List<AssetProperty> assetProperties;

    private final List<AssetHierarchy> assetHierarchies;

    private final Instant assetCreationDate;

    private final Instant assetLastUpdateDate;

    private final AssetStatus assetStatus;

    private DescribeAssetResponse(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.assetArn = builder.assetArn;
        this.assetName = builder.assetName;
        this.assetModelId = builder.assetModelId;
        this.assetProperties = builder.assetProperties;
        this.assetHierarchies = builder.assetHierarchies;
        this.assetCreationDate = builder.assetCreationDate;
        this.assetLastUpdateDate = builder.assetLastUpdateDate;
        this.assetStatus = builder.assetStatus;
    }

    /**
     * <p>
     * The ID of the asset.
     * </p>
     * 
     * @return The ID of the asset.
     */
    public String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset,
     * which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         asset, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
     */
    public String assetArn() {
        return assetArn;
    }

    /**
     * <p>
     * The name of the asset.
     * </p>
     * 
     * @return The name of the asset.
     */
    public String assetName() {
        return assetName;
    }

    /**
     * <p>
     * The ID of the asset model that was used to create the asset.
     * </p>
     * 
     * @return The ID of the asset model that was used to create the asset.
     */
    public String assetModelId() {
        return assetModelId;
    }

    /**
     * Returns true if the AssetProperties property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAssetProperties() {
        return assetProperties != null && !(assetProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of asset properties for the asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssetProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of asset properties for the asset.
     */
    public List<AssetProperty> assetProperties() {
        return assetProperties;
    }

    /**
     * Returns true if the AssetHierarchies property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAssetHierarchies() {
        return assetHierarchies != null && !(assetHierarchies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
     * parent/child asset relationships.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssetHierarchies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
     *         parent/child asset relationships.
     */
    public List<AssetHierarchy> assetHierarchies() {
        return assetHierarchies;
    }

    /**
     * <p>
     * The date the asset was created, in Unix epoch time.
     * </p>
     * 
     * @return The date the asset was created, in Unix epoch time.
     */
    public Instant assetCreationDate() {
        return assetCreationDate;
    }

    /**
     * <p>
     * The date the asset was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the asset was last updated, in Unix epoch time.
     */
    public Instant assetLastUpdateDate() {
        return assetLastUpdateDate;
    }

    /**
     * <p>
     * The current status of the asset, which contains a state and any error message.
     * </p>
     * 
     * @return The current status of the asset, which contains a state and any error message.
     */
    public AssetStatus assetStatus() {
        return assetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(assetArn());
        hashCode = 31 * hashCode + Objects.hashCode(assetName());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetProperties());
        hashCode = 31 * hashCode + Objects.hashCode(assetHierarchies());
        hashCode = 31 * hashCode + Objects.hashCode(assetCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(assetLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(assetStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetResponse)) {
            return false;
        }
        DescribeAssetResponse other = (DescribeAssetResponse) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(assetArn(), other.assetArn())
                && Objects.equals(assetName(), other.assetName()) && Objects.equals(assetModelId(), other.assetModelId())
                && Objects.equals(assetProperties(), other.assetProperties())
                && Objects.equals(assetHierarchies(), other.assetHierarchies())
                && Objects.equals(assetCreationDate(), other.assetCreationDate())
                && Objects.equals(assetLastUpdateDate(), other.assetLastUpdateDate())
                && Objects.equals(assetStatus(), other.assetStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAssetResponse").add("AssetId", assetId()).add("AssetArn", assetArn())
                .add("AssetName", assetName()).add("AssetModelId", assetModelId()).add("AssetProperties", assetProperties())
                .add("AssetHierarchies", assetHierarchies()).add("AssetCreationDate", assetCreationDate())
                .add("AssetLastUpdateDate", assetLastUpdateDate()).add("AssetStatus", assetStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "assetArn":
            return Optional.ofNullable(clazz.cast(assetArn()));
        case "assetName":
            return Optional.ofNullable(clazz.cast(assetName()));
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "assetProperties":
            return Optional.ofNullable(clazz.cast(assetProperties()));
        case "assetHierarchies":
            return Optional.ofNullable(clazz.cast(assetHierarchies()));
        case "assetCreationDate":
            return Optional.ofNullable(clazz.cast(assetCreationDate()));
        case "assetLastUpdateDate":
            return Optional.ofNullable(clazz.cast(assetLastUpdateDate()));
        case "assetStatus":
            return Optional.ofNullable(clazz.cast(assetStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetResponse, T> g) {
        return obj -> g.apply((DescribeAssetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAssetResponse> {
        /**
         * <p>
         * The ID of the asset.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * asset, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
         * </p>
         * 
         * @param assetArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the asset, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetArn(String assetArn);

        /**
         * <p>
         * The name of the asset.
         * </p>
         * 
         * @param assetName
         *        The name of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetName(String assetName);

        /**
         * <p>
         * The ID of the asset model that was used to create the asset.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model that was used to create the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The list of asset properties for the asset.
         * </p>
         * 
         * @param assetProperties
         *        The list of asset properties for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetProperties(Collection<AssetProperty> assetProperties);

        /**
         * <p>
         * The list of asset properties for the asset.
         * </p>
         * 
         * @param assetProperties
         *        The list of asset properties for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetProperties(AssetProperty... assetProperties);

        /**
         * <p>
         * The list of asset properties for the asset.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssetProperty>.Builder} avoiding the need
         * to create one manually via {@link List<AssetProperty>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetProperty>.Builder#build()} is called immediately and
         * its result is passed to {@link #assetProperties(List<AssetProperty>)}.
         * 
         * @param assetProperties
         *        a consumer that will call methods on {@link List<AssetProperty>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetProperties(List<AssetProperty>)
         */
        Builder assetProperties(Consumer<AssetProperty.Builder>... assetProperties);

        /**
         * <p>
         * A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
         * parent/child asset relationships.
         * </p>
         * 
         * @param assetHierarchies
         *        A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies
         *        allowed parent/child asset relationships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetHierarchies(Collection<AssetHierarchy> assetHierarchies);

        /**
         * <p>
         * A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
         * parent/child asset relationships.
         * </p>
         * 
         * @param assetHierarchies
         *        A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies
         *        allowed parent/child asset relationships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetHierarchies(AssetHierarchy... assetHierarchies);

        /**
         * <p>
         * A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
         * parent/child asset relationships.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssetHierarchy>.Builder} avoiding the need
         * to create one manually via {@link List<AssetHierarchy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetHierarchy>.Builder#build()} is called immediately and
         * its result is passed to {@link #assetHierarchies(List<AssetHierarchy>)}.
         * 
         * @param assetHierarchies
         *        a consumer that will call methods on {@link List<AssetHierarchy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetHierarchies(List<AssetHierarchy>)
         */
        Builder assetHierarchies(Consumer<AssetHierarchy.Builder>... assetHierarchies);

        /**
         * <p>
         * The date the asset was created, in Unix epoch time.
         * </p>
         * 
         * @param assetCreationDate
         *        The date the asset was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCreationDate(Instant assetCreationDate);

        /**
         * <p>
         * The date the asset was last updated, in Unix epoch time.
         * </p>
         * 
         * @param assetLastUpdateDate
         *        The date the asset was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetLastUpdateDate(Instant assetLastUpdateDate);

        /**
         * <p>
         * The current status of the asset, which contains a state and any error message.
         * </p>
         * 
         * @param assetStatus
         *        The current status of the asset, which contains a state and any error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetStatus(AssetStatus assetStatus);

        /**
         * <p>
         * The current status of the asset, which contains a state and any error message.
         * </p>
         * This is a convenience that creates an instance of the {@link AssetStatus.Builder} avoiding the need to create
         * one manually via {@link AssetStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssetStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #assetStatus(AssetStatus)}.
         * 
         * @param assetStatus
         *        a consumer that will call methods on {@link AssetStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetStatus(AssetStatus)
         */
        default Builder assetStatus(Consumer<AssetStatus.Builder> assetStatus) {
            return assetStatus(AssetStatus.builder().applyMutation(assetStatus).build());
        }
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String assetId;

        private String assetArn;

        private String assetName;

        private String assetModelId;

        private List<AssetProperty> assetProperties = DefaultSdkAutoConstructList.getInstance();

        private List<AssetHierarchy> assetHierarchies = DefaultSdkAutoConstructList.getInstance();

        private Instant assetCreationDate;

        private Instant assetLastUpdateDate;

        private AssetStatus assetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetResponse model) {
            super(model);
            assetId(model.assetId);
            assetArn(model.assetArn);
            assetName(model.assetName);
            assetModelId(model.assetModelId);
            assetProperties(model.assetProperties);
            assetHierarchies(model.assetHierarchies);
            assetCreationDate(model.assetCreationDate);
            assetLastUpdateDate(model.assetLastUpdateDate);
            assetStatus(model.assetStatus);
        }

        public final String getAssetId() {
            return assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        public final String getAssetArn() {
            return assetArn;
        }

        @Override
        public final Builder assetArn(String assetArn) {
            this.assetArn = assetArn;
            return this;
        }

        public final void setAssetArn(String assetArn) {
            this.assetArn = assetArn;
        }

        public final String getAssetName() {
            return assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        public final Collection<AssetProperty.Builder> getAssetProperties() {
            return assetProperties != null ? assetProperties.stream().map(AssetProperty::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder assetProperties(Collection<AssetProperty> assetProperties) {
            this.assetProperties = AssetPropertiesCopier.copy(assetProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetProperties(AssetProperty... assetProperties) {
            assetProperties(Arrays.asList(assetProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetProperties(Consumer<AssetProperty.Builder>... assetProperties) {
            assetProperties(Stream.of(assetProperties).map(c -> AssetProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAssetProperties(Collection<AssetProperty.BuilderImpl> assetProperties) {
            this.assetProperties = AssetPropertiesCopier.copyFromBuilder(assetProperties);
        }

        public final Collection<AssetHierarchy.Builder> getAssetHierarchies() {
            return assetHierarchies != null ? assetHierarchies.stream().map(AssetHierarchy::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assetHierarchies(Collection<AssetHierarchy> assetHierarchies) {
            this.assetHierarchies = AssetHierarchiesCopier.copy(assetHierarchies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetHierarchies(AssetHierarchy... assetHierarchies) {
            assetHierarchies(Arrays.asList(assetHierarchies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetHierarchies(Consumer<AssetHierarchy.Builder>... assetHierarchies) {
            assetHierarchies(Stream.of(assetHierarchies).map(c -> AssetHierarchy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAssetHierarchies(Collection<AssetHierarchy.BuilderImpl> assetHierarchies) {
            this.assetHierarchies = AssetHierarchiesCopier.copyFromBuilder(assetHierarchies);
        }

        public final Instant getAssetCreationDate() {
            return assetCreationDate;
        }

        @Override
        public final Builder assetCreationDate(Instant assetCreationDate) {
            this.assetCreationDate = assetCreationDate;
            return this;
        }

        public final void setAssetCreationDate(Instant assetCreationDate) {
            this.assetCreationDate = assetCreationDate;
        }

        public final Instant getAssetLastUpdateDate() {
            return assetLastUpdateDate;
        }

        @Override
        public final Builder assetLastUpdateDate(Instant assetLastUpdateDate) {
            this.assetLastUpdateDate = assetLastUpdateDate;
            return this;
        }

        public final void setAssetLastUpdateDate(Instant assetLastUpdateDate) {
            this.assetLastUpdateDate = assetLastUpdateDate;
        }

        public final AssetStatus.Builder getAssetStatus() {
            return assetStatus != null ? assetStatus.toBuilder() : null;
        }

        @Override
        public final Builder assetStatus(AssetStatus assetStatus) {
            this.assetStatus = assetStatus;
            return this;
        }

        public final void setAssetStatus(AssetStatus.BuilderImpl assetStatus) {
            this.assetStatus = assetStatus != null ? assetStatus.build() : null;
        }

        @Override
        public DescribeAssetResponse build() {
            return new DescribeAssetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
