/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssetPropertyResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeAssetPropertyResponse.Builder, DescribeAssetPropertyResponse> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAssetPropertyResponse::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAssetPropertyResponse::assetName)).setter(setter(Builder::assetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetName").build()).build();

    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAssetPropertyResponse::assetModelId)).setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()).build();

    private static final SdkField<Property> ASSET_PROPERTY_FIELD = SdkField.<Property> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeAssetPropertyResponse::assetProperty)).setter(setter(Builder::assetProperty))
            .constructor(Property::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetProperty").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            ASSET_NAME_FIELD, ASSET_MODEL_ID_FIELD, ASSET_PROPERTY_FIELD));

    private final String assetId;

    private final String assetName;

    private final String assetModelId;

    private final Property assetProperty;

    private DescribeAssetPropertyResponse(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.assetName = builder.assetName;
        this.assetModelId = builder.assetModelId;
        this.assetProperty = builder.assetProperty;
    }

    /**
     * <p>
     * The ID of the asset.
     * </p>
     * 
     * @return The ID of the asset.
     */
    public String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The name of the asset.
     * </p>
     * 
     * @return The name of the asset.
     */
    public String assetName() {
        return assetName;
    }

    /**
     * <p>
     * The ID of the asset model.
     * </p>
     * 
     * @return The ID of the asset model.
     */
    public String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The asset property's definition, alias, and notification state.
     * </p>
     * 
     * @return The asset property's definition, alias, and notification state.
     */
    public Property assetProperty() {
        return assetProperty;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(assetName());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetProperty());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetPropertyResponse)) {
            return false;
        }
        DescribeAssetPropertyResponse other = (DescribeAssetPropertyResponse) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(assetName(), other.assetName())
                && Objects.equals(assetModelId(), other.assetModelId()) && Objects.equals(assetProperty(), other.assetProperty());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAssetPropertyResponse").add("AssetId", assetId()).add("AssetName", assetName())
                .add("AssetModelId", assetModelId()).add("AssetProperty", assetProperty()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "assetName":
            return Optional.ofNullable(clazz.cast(assetName()));
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "assetProperty":
            return Optional.ofNullable(clazz.cast(assetProperty()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetPropertyResponse, T> g) {
        return obj -> g.apply((DescribeAssetPropertyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAssetPropertyResponse> {
        /**
         * <p>
         * The ID of the asset.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The name of the asset.
         * </p>
         * 
         * @param assetName
         *        The name of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetName(String assetName);

        /**
         * <p>
         * The ID of the asset model.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The asset property's definition, alias, and notification state.
         * </p>
         * 
         * @param assetProperty
         *        The asset property's definition, alias, and notification state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetProperty(Property assetProperty);

        /**
         * <p>
         * The asset property's definition, alias, and notification state.
         * </p>
         * This is a convenience that creates an instance of the {@link Property.Builder} avoiding the need to create
         * one manually via {@link Property#builder()}.
         *
         * When the {@link Consumer} completes, {@link Property.Builder#build()} is called immediately and its result is
         * passed to {@link #assetProperty(Property)}.
         * 
         * @param assetProperty
         *        a consumer that will call methods on {@link Property.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetProperty(Property)
         */
        default Builder assetProperty(Consumer<Property.Builder> assetProperty) {
            return assetProperty(Property.builder().applyMutation(assetProperty).build());
        }
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String assetId;

        private String assetName;

        private String assetModelId;

        private Property assetProperty;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetPropertyResponse model) {
            super(model);
            assetId(model.assetId);
            assetName(model.assetName);
            assetModelId(model.assetModelId);
            assetProperty(model.assetProperty);
        }

        public final String getAssetId() {
            return assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        public final String getAssetName() {
            return assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        public final Property.Builder getAssetProperty() {
            return assetProperty != null ? assetProperty.toBuilder() : null;
        }

        @Override
        public final Builder assetProperty(Property assetProperty) {
            this.assetProperty = assetProperty;
            return this;
        }

        public final void setAssetProperty(Property.BuilderImpl assetProperty) {
            this.assetProperty = assetProperty != null ? assetProperty.build() : null;
        }

        @Override
        public DescribeAssetPropertyResponse build() {
            return new DescribeAssetPropertyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
