/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssetModelResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeAssetModelResponse.Builder, DescribeAssetModelResponse> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAssetModelResponse::assetModelId)).setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()).build();

    private static final SdkField<String> ASSET_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAssetModelResponse::assetModelArn)).setter(setter(Builder::assetModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelArn").build()).build();

    private static final SdkField<String> ASSET_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAssetModelResponse::assetModelName)).setter(setter(Builder::assetModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelName").build()).build();

    private static final SdkField<String> ASSET_MODEL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAssetModelResponse::assetModelDescription)).setter(setter(Builder::assetModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelDescription").build())
            .build();

    private static final SdkField<List<AssetModelProperty>> ASSET_MODEL_PROPERTIES_FIELD = SdkField
            .<List<AssetModelProperty>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAssetModelResponse::assetModelProperties))
            .setter(setter(Builder::assetModelProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetModelHierarchy>> ASSET_MODEL_HIERARCHIES_FIELD = SdkField
            .<List<AssetModelHierarchy>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAssetModelResponse::assetModelHierarchies))
            .setter(setter(Builder::assetModelHierarchies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelHierarchies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelHierarchy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelHierarchy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> ASSET_MODEL_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeAssetModelResponse::assetModelCreationDate)).setter(setter(Builder::assetModelCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCreationDate").build())
            .build();

    private static final SdkField<Instant> ASSET_MODEL_LAST_UPDATE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).getter(getter(DescribeAssetModelResponse::assetModelLastUpdateDate))
            .setter(setter(Builder::assetModelLastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelLastUpdateDate").build())
            .build();

    private static final SdkField<AssetModelStatus> ASSET_MODEL_STATUS_FIELD = SdkField
            .<AssetModelStatus> builder(MarshallingType.SDK_POJO).getter(getter(DescribeAssetModelResponse::assetModelStatus))
            .setter(setter(Builder::assetModelStatus)).constructor(AssetModelStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD,
            ASSET_MODEL_ARN_FIELD, ASSET_MODEL_NAME_FIELD, ASSET_MODEL_DESCRIPTION_FIELD, ASSET_MODEL_PROPERTIES_FIELD,
            ASSET_MODEL_HIERARCHIES_FIELD, ASSET_MODEL_CREATION_DATE_FIELD, ASSET_MODEL_LAST_UPDATE_DATE_FIELD,
            ASSET_MODEL_STATUS_FIELD));

    private final String assetModelId;

    private final String assetModelArn;

    private final String assetModelName;

    private final String assetModelDescription;

    private final List<AssetModelProperty> assetModelProperties;

    private final List<AssetModelHierarchy> assetModelHierarchies;

    private final Instant assetModelCreationDate;

    private final Instant assetModelLastUpdateDate;

    private final AssetModelStatus assetModelStatus;

    private DescribeAssetModelResponse(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.assetModelArn = builder.assetModelArn;
        this.assetModelName = builder.assetModelName;
        this.assetModelDescription = builder.assetModelDescription;
        this.assetModelProperties = builder.assetModelProperties;
        this.assetModelHierarchies = builder.assetModelHierarchies;
        this.assetModelCreationDate = builder.assetModelCreationDate;
        this.assetModelLastUpdateDate = builder.assetModelLastUpdateDate;
        this.assetModelStatus = builder.assetModelStatus;
    }

    /**
     * <p>
     * The ID of the asset model.
     * </p>
     * 
     * @return The ID of the asset model.
     */
    public String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset
     * model, which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         asset model, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code>
     */
    public String assetModelArn() {
        return assetModelArn;
    }

    /**
     * <p>
     * The name of the asset model.
     * </p>
     * 
     * @return The name of the asset model.
     */
    public String assetModelName() {
        return assetModelName;
    }

    /**
     * <p>
     * The asset model's description.
     * </p>
     * 
     * @return The asset model's description.
     */
    public String assetModelDescription() {
        return assetModelDescription;
    }

    /**
     * Returns true if the AssetModelProperties property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAssetModelProperties() {
        return assetModelProperties != null && !(assetModelProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of asset properties for the asset model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssetModelProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of asset properties for the asset model.
     */
    public List<AssetModelProperty> assetModelProperties() {
        return assetModelProperties;
    }

    /**
     * Returns true if the AssetModelHierarchies property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAssetModelHierarchies() {
        return assetModelHierarchies != null && !(assetModelHierarchies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a
     * <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset relationships
     * for an asset model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssetModelHierarchies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a
     *         <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset
     *         relationships for an asset model.
     */
    public List<AssetModelHierarchy> assetModelHierarchies() {
        return assetModelHierarchies;
    }

    /**
     * <p>
     * The date the asset model was created, in Unix epoch time.
     * </p>
     * 
     * @return The date the asset model was created, in Unix epoch time.
     */
    public Instant assetModelCreationDate() {
        return assetModelCreationDate;
    }

    /**
     * <p>
     * The date the asset model was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the asset model was last updated, in Unix epoch time.
     */
    public Instant assetModelLastUpdateDate() {
        return assetModelLastUpdateDate;
    }

    /**
     * <p>
     * The current status of the asset model, which contains a state and any error message.
     * </p>
     * 
     * @return The current status of the asset model, which contains a state and any error message.
     */
    public AssetModelStatus assetModelStatus() {
        return assetModelStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelName());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelProperties());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelHierarchies());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetModelResponse)) {
            return false;
        }
        DescribeAssetModelResponse other = (DescribeAssetModelResponse) obj;
        return Objects.equals(assetModelId(), other.assetModelId()) && Objects.equals(assetModelArn(), other.assetModelArn())
                && Objects.equals(assetModelName(), other.assetModelName())
                && Objects.equals(assetModelDescription(), other.assetModelDescription())
                && Objects.equals(assetModelProperties(), other.assetModelProperties())
                && Objects.equals(assetModelHierarchies(), other.assetModelHierarchies())
                && Objects.equals(assetModelCreationDate(), other.assetModelCreationDate())
                && Objects.equals(assetModelLastUpdateDate(), other.assetModelLastUpdateDate())
                && Objects.equals(assetModelStatus(), other.assetModelStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAssetModelResponse").add("AssetModelId", assetModelId())
                .add("AssetModelArn", assetModelArn()).add("AssetModelName", assetModelName())
                .add("AssetModelDescription", assetModelDescription()).add("AssetModelProperties", assetModelProperties())
                .add("AssetModelHierarchies", assetModelHierarchies()).add("AssetModelCreationDate", assetModelCreationDate())
                .add("AssetModelLastUpdateDate", assetModelLastUpdateDate()).add("AssetModelStatus", assetModelStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "assetModelArn":
            return Optional.ofNullable(clazz.cast(assetModelArn()));
        case "assetModelName":
            return Optional.ofNullable(clazz.cast(assetModelName()));
        case "assetModelDescription":
            return Optional.ofNullable(clazz.cast(assetModelDescription()));
        case "assetModelProperties":
            return Optional.ofNullable(clazz.cast(assetModelProperties()));
        case "assetModelHierarchies":
            return Optional.ofNullable(clazz.cast(assetModelHierarchies()));
        case "assetModelCreationDate":
            return Optional.ofNullable(clazz.cast(assetModelCreationDate()));
        case "assetModelLastUpdateDate":
            return Optional.ofNullable(clazz.cast(assetModelLastUpdateDate()));
        case "assetModelStatus":
            return Optional.ofNullable(clazz.cast(assetModelStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetModelResponse, T> g) {
        return obj -> g.apply((DescribeAssetModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAssetModelResponse> {
        /**
         * <p>
         * The ID of the asset model.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset
         * model, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code>
         * </p>
         * 
         * @param assetModelArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the asset model, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelArn(String assetModelArn);

        /**
         * <p>
         * The name of the asset model.
         * </p>
         * 
         * @param assetModelName
         *        The name of the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelName(String assetModelName);

        /**
         * <p>
         * The asset model's description.
         * </p>
         * 
         * @param assetModelDescription
         *        The asset model's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelDescription(String assetModelDescription);

        /**
         * <p>
         * The list of asset properties for the asset model.
         * </p>
         * 
         * @param assetModelProperties
         *        The list of asset properties for the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelProperties(Collection<AssetModelProperty> assetModelProperties);

        /**
         * <p>
         * The list of asset properties for the asset model.
         * </p>
         * 
         * @param assetModelProperties
         *        The list of asset properties for the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelProperties(AssetModelProperty... assetModelProperties);

        /**
         * <p>
         * The list of asset properties for the asset model.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssetModelProperty>.Builder} avoiding the
         * need to create one manually via {@link List<AssetModelProperty>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetModelProperty>.Builder#build()} is called immediately
         * and its result is passed to {@link #assetModelProperties(List<AssetModelProperty>)}.
         * 
         * @param assetModelProperties
         *        a consumer that will call methods on {@link List<AssetModelProperty>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelProperties(List<AssetModelProperty>)
         */
        Builder assetModelProperties(Consumer<AssetModelProperty.Builder>... assetModelProperties);

        /**
         * <p>
         * A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a
         * <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset
         * relationships for an asset model.
         * </p>
         * 
         * @param assetModelHierarchies
         *        A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a
         *        <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset
         *        relationships for an asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelHierarchies(Collection<AssetModelHierarchy> assetModelHierarchies);

        /**
         * <p>
         * A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a
         * <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset
         * relationships for an asset model.
         * </p>
         * 
         * @param assetModelHierarchies
         *        A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a
         *        <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset
         *        relationships for an asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelHierarchies(AssetModelHierarchy... assetModelHierarchies);

        /**
         * <p>
         * A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a
         * <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset
         * relationships for an asset model.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssetModelHierarchy>.Builder} avoiding the
         * need to create one manually via {@link List<AssetModelHierarchy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetModelHierarchy>.Builder#build()} is called immediately
         * and its result is passed to {@link #assetModelHierarchies(List<AssetModelHierarchy>)}.
         * 
         * @param assetModelHierarchies
         *        a consumer that will call methods on {@link List<AssetModelHierarchy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelHierarchies(List<AssetModelHierarchy>)
         */
        Builder assetModelHierarchies(Consumer<AssetModelHierarchy.Builder>... assetModelHierarchies);

        /**
         * <p>
         * The date the asset model was created, in Unix epoch time.
         * </p>
         * 
         * @param assetModelCreationDate
         *        The date the asset model was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCreationDate(Instant assetModelCreationDate);

        /**
         * <p>
         * The date the asset model was last updated, in Unix epoch time.
         * </p>
         * 
         * @param assetModelLastUpdateDate
         *        The date the asset model was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelLastUpdateDate(Instant assetModelLastUpdateDate);

        /**
         * <p>
         * The current status of the asset model, which contains a state and any error message.
         * </p>
         * 
         * @param assetModelStatus
         *        The current status of the asset model, which contains a state and any error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelStatus(AssetModelStatus assetModelStatus);

        /**
         * <p>
         * The current status of the asset model, which contains a state and any error message.
         * </p>
         * This is a convenience that creates an instance of the {@link AssetModelStatus.Builder} avoiding the need to
         * create one manually via {@link AssetModelStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssetModelStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #assetModelStatus(AssetModelStatus)}.
         * 
         * @param assetModelStatus
         *        a consumer that will call methods on {@link AssetModelStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelStatus(AssetModelStatus)
         */
        default Builder assetModelStatus(Consumer<AssetModelStatus.Builder> assetModelStatus) {
            return assetModelStatus(AssetModelStatus.builder().applyMutation(assetModelStatus).build());
        }
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String assetModelId;

        private String assetModelArn;

        private String assetModelName;

        private String assetModelDescription;

        private List<AssetModelProperty> assetModelProperties = DefaultSdkAutoConstructList.getInstance();

        private List<AssetModelHierarchy> assetModelHierarchies = DefaultSdkAutoConstructList.getInstance();

        private Instant assetModelCreationDate;

        private Instant assetModelLastUpdateDate;

        private AssetModelStatus assetModelStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetModelResponse model) {
            super(model);
            assetModelId(model.assetModelId);
            assetModelArn(model.assetModelArn);
            assetModelName(model.assetModelName);
            assetModelDescription(model.assetModelDescription);
            assetModelProperties(model.assetModelProperties);
            assetModelHierarchies(model.assetModelHierarchies);
            assetModelCreationDate(model.assetModelCreationDate);
            assetModelLastUpdateDate(model.assetModelLastUpdateDate);
            assetModelStatus(model.assetModelStatus);
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        public final String getAssetModelArn() {
            return assetModelArn;
        }

        @Override
        public final Builder assetModelArn(String assetModelArn) {
            this.assetModelArn = assetModelArn;
            return this;
        }

        public final void setAssetModelArn(String assetModelArn) {
            this.assetModelArn = assetModelArn;
        }

        public final String getAssetModelName() {
            return assetModelName;
        }

        @Override
        public final Builder assetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
            return this;
        }

        public final void setAssetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
        }

        public final String getAssetModelDescription() {
            return assetModelDescription;
        }

        @Override
        public final Builder assetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
            return this;
        }

        public final void setAssetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
        }

        public final Collection<AssetModelProperty.Builder> getAssetModelProperties() {
            return assetModelProperties != null ? assetModelProperties.stream().map(AssetModelProperty::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assetModelProperties(Collection<AssetModelProperty> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertiesCopier.copy(assetModelProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelProperties(AssetModelProperty... assetModelProperties) {
            assetModelProperties(Arrays.asList(assetModelProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelProperties(Consumer<AssetModelProperty.Builder>... assetModelProperties) {
            assetModelProperties(Stream.of(assetModelProperties).map(c -> AssetModelProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAssetModelProperties(Collection<AssetModelProperty.BuilderImpl> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertiesCopier.copyFromBuilder(assetModelProperties);
        }

        public final Collection<AssetModelHierarchy.Builder> getAssetModelHierarchies() {
            return assetModelHierarchies != null ? assetModelHierarchies.stream().map(AssetModelHierarchy::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assetModelHierarchies(Collection<AssetModelHierarchy> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchiesCopier.copy(assetModelHierarchies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelHierarchies(AssetModelHierarchy... assetModelHierarchies) {
            assetModelHierarchies(Arrays.asList(assetModelHierarchies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelHierarchies(Consumer<AssetModelHierarchy.Builder>... assetModelHierarchies) {
            assetModelHierarchies(Stream.of(assetModelHierarchies)
                    .map(c -> AssetModelHierarchy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssetModelHierarchies(Collection<AssetModelHierarchy.BuilderImpl> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchiesCopier.copyFromBuilder(assetModelHierarchies);
        }

        public final Instant getAssetModelCreationDate() {
            return assetModelCreationDate;
        }

        @Override
        public final Builder assetModelCreationDate(Instant assetModelCreationDate) {
            this.assetModelCreationDate = assetModelCreationDate;
            return this;
        }

        public final void setAssetModelCreationDate(Instant assetModelCreationDate) {
            this.assetModelCreationDate = assetModelCreationDate;
        }

        public final Instant getAssetModelLastUpdateDate() {
            return assetModelLastUpdateDate;
        }

        @Override
        public final Builder assetModelLastUpdateDate(Instant assetModelLastUpdateDate) {
            this.assetModelLastUpdateDate = assetModelLastUpdateDate;
            return this;
        }

        public final void setAssetModelLastUpdateDate(Instant assetModelLastUpdateDate) {
            this.assetModelLastUpdateDate = assetModelLastUpdateDate;
        }

        public final AssetModelStatus.Builder getAssetModelStatus() {
            return assetModelStatus != null ? assetModelStatus.toBuilder() : null;
        }

        @Override
        public final Builder assetModelStatus(AssetModelStatus assetModelStatus) {
            this.assetModelStatus = assetModelStatus;
            return this;
        }

        public final void setAssetModelStatus(AssetModelStatus.BuilderImpl assetModelStatus) {
            this.assetModelStatus = assetModelStatus != null ? assetModelStatus.build() : null;
        }

        @Override
        public DescribeAssetModelResponse build() {
            return new DescribeAssetModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
