/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotsitewise.model.Identity;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.Permission;
import software.amazon.awssdk.services.iotsitewise.model.Resource;
import software.amazon.awssdk.services.iotsitewise.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessPolicyRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, CreateAccessPolicyRequest> {
    private static final SdkField<Identity> ACCESS_POLICY_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateAccessPolicyRequest.getter(CreateAccessPolicyRequest::accessPolicyIdentity)).setter(CreateAccessPolicyRequest.setter(Builder::accessPolicyIdentity)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyIdentity").build()}).build();
    private static final SdkField<Resource> ACCESS_POLICY_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateAccessPolicyRequest.getter(CreateAccessPolicyRequest::accessPolicyResource)).setter(CreateAccessPolicyRequest.setter(Builder::accessPolicyResource)).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyResource").build()}).build();
    private static final SdkField<String> ACCESS_POLICY_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAccessPolicyRequest.getter(CreateAccessPolicyRequest::accessPolicyPermissionAsString)).setter(CreateAccessPolicyRequest.setter(Builder::accessPolicyPermission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyPermission").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAccessPolicyRequest.getter(CreateAccessPolicyRequest::clientToken)).setter(CreateAccessPolicyRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateAccessPolicyRequest.getter(CreateAccessPolicyRequest::tags)).setter(CreateAccessPolicyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICY_IDENTITY_FIELD, ACCESS_POLICY_RESOURCE_FIELD, ACCESS_POLICY_PERMISSION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private final Identity accessPolicyIdentity;
    private final Resource accessPolicyResource;
    private final String accessPolicyPermission;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateAccessPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.accessPolicyIdentity = builder.accessPolicyIdentity;
        this.accessPolicyResource = builder.accessPolicyResource;
        this.accessPolicyPermission = builder.accessPolicyPermission;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public Identity accessPolicyIdentity() {
        return this.accessPolicyIdentity;
    }

    public Resource accessPolicyResource() {
        return this.accessPolicyResource;
    }

    public Permission accessPolicyPermission() {
        return Permission.fromValue(this.accessPolicyPermission);
    }

    public String accessPolicyPermissionAsString() {
        return this.accessPolicyPermission;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicyIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicyResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicyPermissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessPolicyRequest)) {
            return false;
        }
        CreateAccessPolicyRequest other = (CreateAccessPolicyRequest)((Object)obj);
        return Objects.equals(this.accessPolicyIdentity(), other.accessPolicyIdentity()) && Objects.equals(this.accessPolicyResource(), other.accessPolicyResource()) && Objects.equals(this.accessPolicyPermissionAsString(), other.accessPolicyPermissionAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateAccessPolicyRequest").add("AccessPolicyIdentity", (Object)this.accessPolicyIdentity()).add("AccessPolicyResource", (Object)this.accessPolicyResource()).add("AccessPolicyPermission", (Object)this.accessPolicyPermissionAsString()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessPolicyIdentity": {
                return Optional.ofNullable(clazz.cast(this.accessPolicyIdentity()));
            }
            case "accessPolicyResource": {
                return Optional.ofNullable(clazz.cast(this.accessPolicyResource()));
            }
            case "accessPolicyPermission": {
                return Optional.ofNullable(clazz.cast(this.accessPolicyPermissionAsString()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessPolicyRequest, T> g) {
        return obj -> g.apply((CreateAccessPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private Identity accessPolicyIdentity;
        private Resource accessPolicyResource;
        private String accessPolicyPermission;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessPolicyRequest model) {
            super(model);
            this.accessPolicyIdentity(model.accessPolicyIdentity);
            this.accessPolicyResource(model.accessPolicyResource);
            this.accessPolicyPermission(model.accessPolicyPermission);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final Identity.Builder getAccessPolicyIdentity() {
            return this.accessPolicyIdentity != null ? this.accessPolicyIdentity.toBuilder() : null;
        }

        @Override
        public final Builder accessPolicyIdentity(Identity accessPolicyIdentity) {
            this.accessPolicyIdentity = accessPolicyIdentity;
            return this;
        }

        public final void setAccessPolicyIdentity(Identity.BuilderImpl accessPolicyIdentity) {
            this.accessPolicyIdentity = accessPolicyIdentity != null ? accessPolicyIdentity.build() : null;
        }

        public final Resource.Builder getAccessPolicyResource() {
            return this.accessPolicyResource != null ? this.accessPolicyResource.toBuilder() : null;
        }

        @Override
        public final Builder accessPolicyResource(Resource accessPolicyResource) {
            this.accessPolicyResource = accessPolicyResource;
            return this;
        }

        public final void setAccessPolicyResource(Resource.BuilderImpl accessPolicyResource) {
            this.accessPolicyResource = accessPolicyResource != null ? accessPolicyResource.build() : null;
        }

        public final String getAccessPolicyPermission() {
            return this.accessPolicyPermission;
        }

        @Override
        public final Builder accessPolicyPermission(String accessPolicyPermission) {
            this.accessPolicyPermission = accessPolicyPermission;
            return this;
        }

        @Override
        public final Builder accessPolicyPermission(Permission accessPolicyPermission) {
            this.accessPolicyPermission(accessPolicyPermission == null ? null : accessPolicyPermission.toString());
            return this;
        }

        public final void setAccessPolicyPermission(String accessPolicyPermission) {
            this.accessPolicyPermission = accessPolicyPermission;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccessPolicyRequest build() {
            return new CreateAccessPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccessPolicyRequest> {
        public Builder accessPolicyIdentity(Identity var1);

        default public Builder accessPolicyIdentity(Consumer<Identity.Builder> accessPolicyIdentity) {
            return this.accessPolicyIdentity((Identity)((Identity.Builder)Identity.builder().applyMutation(accessPolicyIdentity)).build());
        }

        public Builder accessPolicyResource(Resource var1);

        default public Builder accessPolicyResource(Consumer<Resource.Builder> accessPolicyResource) {
            return this.accessPolicyResource((Resource)((Resource.Builder)Resource.builder().applyMutation(accessPolicyResource)).build());
        }

        public Builder accessPolicyPermission(String var1);

        public Builder accessPolicyPermission(Permission var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

