/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The destination configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationConfig.Builder, DestinationConfig> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(DestinationConfig::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<List<String>> SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("services")
            .getter(getter(DestinationConfig::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD,
            SERVICES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String thingName;

    private final List<String> services;

    private DestinationConfig(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.services = builder.services;
    }

    /**
     * <p>
     * The name of the IoT thing to which you want to connect.
     * </p>
     * 
     * @return The name of the IoT thing to which you want to connect.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * Returns true if the Services property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of service names that identity the target application. The AWS IoT client running on the destination
     * device reads this value and uses it to look up a port or an IP address and a port. The AWS IoT client
     * instantiates the local proxy which uses this information to connect to the destination application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of service names that identity the target application. The AWS IoT client running on the
     *         destination device reads this value and uses it to look up a port or an IP address and a port. The AWS
     *         IoT client instantiates the local proxy which uses this information to connect to the destination
     *         application.
     */
    public final List<String> services() {
        return services;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(hasServices() ? services() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConfig)) {
            return false;
        }
        DestinationConfig other = (DestinationConfig) obj;
        return Objects.equals(thingName(), other.thingName()) && hasServices() == other.hasServices()
                && Objects.equals(services(), other.services());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationConfig").add("ThingName", thingName())
                .add("Services", hasServices() ? services() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "services":
            return Optional.ofNullable(clazz.cast(services()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationConfig, T> g) {
        return obj -> g.apply((DestinationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationConfig> {
        /**
         * <p>
         * The name of the IoT thing to which you want to connect.
         * </p>
         * 
         * @param thingName
         *        The name of the IoT thing to which you want to connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * A list of service names that identity the target application. The AWS IoT client running on the destination
         * device reads this value and uses it to look up a port or an IP address and a port. The AWS IoT client
         * instantiates the local proxy which uses this information to connect to the destination application.
         * </p>
         * 
         * @param services
         *        A list of service names that identity the target application. The AWS IoT client running on the
         *        destination device reads this value and uses it to look up a port or an IP address and a port. The AWS
         *        IoT client instantiates the local proxy which uses this information to connect to the destination
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<String> services);

        /**
         * <p>
         * A list of service names that identity the target application. The AWS IoT client running on the destination
         * device reads this value and uses it to look up a port or an IP address and a port. The AWS IoT client
         * instantiates the local proxy which uses this information to connect to the destination application.
         * </p>
         * 
         * @param services
         *        A list of service names that identity the target application. The AWS IoT client running on the
         *        destination device reads this value and uses it to look up a port or an IP address and a port. The AWS
         *        IoT client instantiates the local proxy which uses this information to connect to the destination
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(String... services);
    }

    static final class BuilderImpl implements Builder {
        private String thingName;

        private List<String> services = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationConfig model) {
            thingName(model.thingName);
            services(model.services);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final Collection<String> getServices() {
            if (services instanceof SdkAutoConstructList) {
                return null;
            }
            return services;
        }

        @Override
        public final Builder services(Collection<String> services) {
            this.services = ServiceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(String... services) {
            services(Arrays.asList(services));
            return this;
        }

        public final void setServices(Collection<String> services) {
            this.services = ServiceListCopier.copy(services);
        }

        @Override
        public DestinationConfig build() {
            return new DestinationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
