/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsecuretunneling.model.ServiceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationConfig> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(DestinationConfig.getter(DestinationConfig::thingName)).setter(DestinationConfig.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()}).build();
    private static final SdkField<List<String>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("services").getter(DestinationConfig.getter(DestinationConfig::services)).setter(DestinationConfig.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD, SERVICES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String thingName;
    private final List<String> services;

    private DestinationConfig(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.services = builder.services;
    }

    public String thingName() {
        return this.thingName;
    }

    public boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public List<String> services() {
        return this.services;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.services() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConfig)) {
            return false;
        }
        DestinationConfig other = (DestinationConfig)obj;
        return Objects.equals(this.thingName(), other.thingName()) && this.hasServices() == other.hasServices() && Objects.equals(this.services(), other.services());
    }

    public String toString() {
        return ToString.builder((String)"DestinationConfig").add("ThingName", (Object)this.thingName()).add("Services", this.hasServices() ? this.services() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationConfig, T> g) {
        return obj -> g.apply((DestinationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingName;
        private List<String> services = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationConfig model) {
            this.thingName(model.thingName);
            this.services(model.services);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final Collection<String> getServices() {
            if (this.services instanceof SdkAutoConstructList) {
                return null;
            }
            return this.services;
        }

        @Override
        public final Builder services(Collection<String> services) {
            this.services = ServiceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(String ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        public final void setServices(Collection<String> services) {
            this.services = ServiceListCopier.copy(services);
        }

        public DestinationConfig build() {
            return new DestinationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationConfig> {
        public Builder thingName(String var1);

        public Builder services(Collection<String> var1);

        public Builder services(String ... var1);
    }
}

