/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsecuretunneling.model.TunnelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TunnelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TunnelSummary> {
    private static final SdkField<String> TUNNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TunnelSummary.getter(TunnelSummary::tunnelId)).setter(TunnelSummary.setter(Builder::tunnelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelId").build()}).build();
    private static final SdkField<String> TUNNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TunnelSummary.getter(TunnelSummary::tunnelArn)).setter(TunnelSummary.setter(Builder::tunnelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TunnelSummary.getter(TunnelSummary::statusAsString)).setter(TunnelSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TunnelSummary.getter(TunnelSummary::description)).setter(TunnelSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TunnelSummary.getter(TunnelSummary::createdAt)).setter(TunnelSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TunnelSummary.getter(TunnelSummary::lastUpdatedAt)).setter(TunnelSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_ID_FIELD, TUNNEL_ARN_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tunnelId;
    private final String tunnelArn;
    private final String status;
    private final String description;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;

    private TunnelSummary(BuilderImpl builder) {
        this.tunnelId = builder.tunnelId;
        this.tunnelArn = builder.tunnelArn;
        this.status = builder.status;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public String tunnelId() {
        return this.tunnelId;
    }

    public String tunnelArn() {
        return this.tunnelArn;
    }

    public TunnelStatus status() {
        return TunnelStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String description() {
        return this.description;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TunnelSummary)) {
            return false;
        }
        TunnelSummary other = (TunnelSummary)obj;
        return Objects.equals(this.tunnelId(), other.tunnelId()) && Objects.equals(this.tunnelArn(), other.tunnelArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public String toString() {
        return ToString.builder((String)"TunnelSummary").add("TunnelId", (Object)this.tunnelId()).add("TunnelArn", (Object)this.tunnelArn()).add("Status", (Object)this.statusAsString()).add("Description", (Object)this.description()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tunnelId": {
                return Optional.ofNullable(clazz.cast(this.tunnelId()));
            }
            case "tunnelArn": {
                return Optional.ofNullable(clazz.cast(this.tunnelArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TunnelSummary, T> g) {
        return obj -> g.apply((TunnelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tunnelId;
        private String tunnelArn;
        private String status;
        private String description;
        private Instant createdAt;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(TunnelSummary model) {
            this.tunnelId(model.tunnelId);
            this.tunnelArn(model.tunnelArn);
            this.status(model.status);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getTunnelId() {
            return this.tunnelId;
        }

        @Override
        public final Builder tunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public final void setTunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
        }

        public final String getTunnelArn() {
            return this.tunnelArn;
        }

        @Override
        public final Builder tunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
            return this;
        }

        public final void setTunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TunnelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public TunnelSummary build() {
            return new TunnelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TunnelSummary> {
        public Builder tunnelId(String var1);

        public Builder tunnelArn(String var1);

        public Builder status(String var1);

        public Builder status(TunnelStatus var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

