/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Tunnel timeout configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeoutConfig implements SdkPojo, Serializable, ToCopyableBuilder<TimeoutConfig.Builder, TimeoutConfig> {
    private static final SdkField<Integer> MAX_LIFETIME_TIMEOUT_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(TimeoutConfig::maxLifetimeTimeoutMinutes))
            .setter(setter(Builder::maxLifetimeTimeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLifetimeTimeoutMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MAX_LIFETIME_TIMEOUT_MINUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxLifetimeTimeoutMinutes;

    private TimeoutConfig(BuilderImpl builder) {
        this.maxLifetimeTimeoutMinutes = builder.maxLifetimeTimeoutMinutes;
    }

    /**
     * <p>
     * The maximum amount of time (in minutes) a tunnel can remain open. If not specified, maxLifetimeTimeoutMinutes
     * defaults to 720 minutes. Valid values are from 1 minute to 12 hours (720 minutes)
     * </p>
     * 
     * @return The maximum amount of time (in minutes) a tunnel can remain open. If not specified,
     *         maxLifetimeTimeoutMinutes defaults to 720 minutes. Valid values are from 1 minute to 12 hours (720
     *         minutes)
     */
    public Integer maxLifetimeTimeoutMinutes() {
        return maxLifetimeTimeoutMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxLifetimeTimeoutMinutes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeoutConfig)) {
            return false;
        }
        TimeoutConfig other = (TimeoutConfig) obj;
        return Objects.equals(maxLifetimeTimeoutMinutes(), other.maxLifetimeTimeoutMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TimeoutConfig").add("MaxLifetimeTimeoutMinutes", maxLifetimeTimeoutMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxLifetimeTimeoutMinutes":
            return Optional.ofNullable(clazz.cast(maxLifetimeTimeoutMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeoutConfig, T> g) {
        return obj -> g.apply((TimeoutConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeoutConfig> {
        /**
         * <p>
         * The maximum amount of time (in minutes) a tunnel can remain open. If not specified, maxLifetimeTimeoutMinutes
         * defaults to 720 minutes. Valid values are from 1 minute to 12 hours (720 minutes)
         * </p>
         * 
         * @param maxLifetimeTimeoutMinutes
         *        The maximum amount of time (in minutes) a tunnel can remain open. If not specified,
         *        maxLifetimeTimeoutMinutes defaults to 720 minutes. Valid values are from 1 minute to 12 hours (720
         *        minutes)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLifetimeTimeoutMinutes(Integer maxLifetimeTimeoutMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxLifetimeTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeoutConfig model) {
            maxLifetimeTimeoutMinutes(model.maxLifetimeTimeoutMinutes);
        }

        public final Integer getMaxLifetimeTimeoutMinutes() {
            return maxLifetimeTimeoutMinutes;
        }

        @Override
        public final Builder maxLifetimeTimeoutMinutes(Integer maxLifetimeTimeoutMinutes) {
            this.maxLifetimeTimeoutMinutes = maxLifetimeTimeoutMinutes;
            return this;
        }

        public final void setMaxLifetimeTimeoutMinutes(Integer maxLifetimeTimeoutMinutes) {
            this.maxLifetimeTimeoutMinutes = maxLifetimeTimeoutMinutes;
        }

        @Override
        public TimeoutConfig build() {
            return new TimeoutConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
