/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotroborunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotroborunner.model.IotRoboRunnerResponse;
import software.amazon.awssdk.services.iotroborunner.model.WorkerFleet;
import software.amazon.awssdk.services.iotroborunner.model.WorkerFleetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkerFleetsResponse
extends IotRoboRunnerResponse
implements ToCopyableBuilder<Builder, ListWorkerFleetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkerFleetsResponse.getter(ListWorkerFleetsResponse::nextToken)).setter(ListWorkerFleetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<WorkerFleet>> WORKER_FLEETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workerFleets").getter(ListWorkerFleetsResponse.getter(ListWorkerFleetsResponse::workerFleets)).setter(ListWorkerFleetsResponse.setter(Builder::workerFleets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerFleets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkerFleet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WORKER_FLEETS_FIELD));
    private final String nextToken;
    private final List<WorkerFleet> workerFleets;

    private ListWorkerFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workerFleets = builder.workerFleets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWorkerFleets() {
        return this.workerFleets != null && !(this.workerFleets instanceof SdkAutoConstructList);
    }

    public final List<WorkerFleet> workerFleets() {
        return this.workerFleets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkerFleets() ? this.workerFleets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkerFleetsResponse)) {
            return false;
        }
        ListWorkerFleetsResponse other = (ListWorkerFleetsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWorkerFleets() == other.hasWorkerFleets() && Objects.equals(this.workerFleets(), other.workerFleets());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkerFleetsResponse").add("NextToken", (Object)this.nextToken()).add("WorkerFleets", this.hasWorkerFleets() ? this.workerFleets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "workerFleets": {
                return Optional.ofNullable(clazz.cast(this.workerFleets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkerFleetsResponse, T> g) {
        return obj -> g.apply((ListWorkerFleetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRoboRunnerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<WorkerFleet> workerFleets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkerFleetsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.workerFleets(model.workerFleets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkerFleet.Builder> getWorkerFleets() {
            List<WorkerFleet.Builder> result = WorkerFleetsCopier.copyToBuilder(this.workerFleets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkerFleets(Collection<WorkerFleet.BuilderImpl> workerFleets) {
            this.workerFleets = WorkerFleetsCopier.copyFromBuilder(workerFleets);
        }

        @Override
        public final Builder workerFleets(Collection<WorkerFleet> workerFleets) {
            this.workerFleets = WorkerFleetsCopier.copy(workerFleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workerFleets(WorkerFleet ... workerFleets) {
            this.workerFleets(Arrays.asList(workerFleets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workerFleets(Consumer<WorkerFleet.Builder> ... workerFleets) {
            this.workerFleets(Stream.of(workerFleets).map(c -> (WorkerFleet)((WorkerFleet.Builder)WorkerFleet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkerFleetsResponse build() {
            return new ListWorkerFleetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRoboRunnerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkerFleetsResponse> {
        public Builder nextToken(String var1);

        public Builder workerFleets(Collection<WorkerFleet> var1);

        public Builder workerFleets(WorkerFleet ... var1);

        public Builder workerFleets(Consumer<WorkerFleet.Builder> ... var1);
    }
}

