/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotroborunner.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotroborunner.IotRoboRunnerClient;
import software.amazon.awssdk.services.iotroborunner.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotroborunner.model.Destination;
import software.amazon.awssdk.services.iotroborunner.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotroborunner.model.ListDestinationsResponse;

public class ListDestinationsIterable
implements SdkIterable<ListDestinationsResponse> {
    private final IotRoboRunnerClient client;
    private final ListDestinationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDestinationsIterable(IotRoboRunnerClient client, ListDestinationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDestinationsResponseFetcher();
    }

    public Iterator<ListDestinationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Destination> destinations() {
        Function<ListDestinationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.destinations() != null) {
                return response.destinations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDestinationsResponseFetcher
    implements SyncPageFetcher<ListDestinationsResponse> {
        private ListDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDestinationsResponse nextPage(ListDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListDestinationsIterable.this.client.listDestinations(ListDestinationsIterable.this.firstRequest);
            }
            return ListDestinationsIterable.this.client.listDestinations((ListDestinationsRequest)((Object)ListDestinationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

