/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ManagedThingSchemaListItem;

public class ListManagedThingSchemasIterable
implements SdkIterable<ListManagedThingSchemasResponse> {
    private final IotManagedIntegrationsClient client;
    private final ListManagedThingSchemasRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedThingSchemasIterable(IotManagedIntegrationsClient client, ListManagedThingSchemasRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListManagedThingSchemasResponseFetcher();
    }

    public Iterator<ListManagedThingSchemasResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedThingSchemaListItem> items() {
        Function<ListManagedThingSchemasResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedThingSchemasResponseFetcher
    implements SyncPageFetcher<ListManagedThingSchemasResponse> {
        private ListManagedThingSchemasResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedThingSchemasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedThingSchemasResponse nextPage(ListManagedThingSchemasResponse previousPage) {
            if (previousPage == null) {
                return ListManagedThingSchemasIterable.this.client.listManagedThingSchemas(ListManagedThingSchemasIterable.this.firstRequest);
            }
            return ListManagedThingSchemasIterable.this.client.listManagedThingSchemas((ListManagedThingSchemasRequest)((Object)ListManagedThingSchemasIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

