/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DiscoveredDeviceSummary;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesResponse;

public class ListDiscoveredDevicesIterable
implements SdkIterable<ListDiscoveredDevicesResponse> {
    private final IotManagedIntegrationsClient client;
    private final ListDiscoveredDevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDiscoveredDevicesIterable(IotManagedIntegrationsClient client, ListDiscoveredDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDiscoveredDevicesResponseFetcher();
    }

    public Iterator<ListDiscoveredDevicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DiscoveredDeviceSummary> items() {
        Function<ListDiscoveredDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDiscoveredDevicesResponseFetcher
    implements SyncPageFetcher<ListDiscoveredDevicesResponse> {
        private ListDiscoveredDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListDiscoveredDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDiscoveredDevicesResponse nextPage(ListDiscoveredDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListDiscoveredDevicesIterable.this.client.listDiscoveredDevices(ListDiscoveredDevicesIterable.this.firstRequest);
            }
            return ListDiscoveredDevicesIterable.this.client.listDiscoveredDevices((ListDiscoveredDevicesRequest)((Object)ListDiscoveredDevicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

