/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsAsyncClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeviceDiscoverySummary;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesResponse;

public class ListDeviceDiscoveriesPublisher
implements SdkPublisher<ListDeviceDiscoveriesResponse> {
    private final IotManagedIntegrationsAsyncClient client;
    private final ListDeviceDiscoveriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeviceDiscoveriesPublisher(IotManagedIntegrationsAsyncClient client, ListDeviceDiscoveriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeviceDiscoveriesPublisher(IotManagedIntegrationsAsyncClient client, ListDeviceDiscoveriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeviceDiscoveriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeviceDiscoveriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DeviceDiscoverySummary> items() {
        Function<ListDeviceDiscoveriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDeviceDiscoveriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDeviceDiscoveriesResponseFetcher
    implements AsyncPageFetcher<ListDeviceDiscoveriesResponse> {
        private ListDeviceDiscoveriesResponseFetcher() {
        }

        public boolean hasNextPage(ListDeviceDiscoveriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeviceDiscoveriesResponse> nextPage(ListDeviceDiscoveriesResponse previousPage) {
            if (previousPage == null) {
                return ListDeviceDiscoveriesPublisher.this.client.listDeviceDiscoveries(ListDeviceDiscoveriesPublisher.this.firstRequest);
            }
            return ListDeviceDiscoveriesPublisher.this.client.listDeviceDiscoveries((ListDeviceDiscoveriesRequest)((Object)ListDeviceDiscoveriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

