/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AssociationState;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountAssociationResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, GetAccountAssociationResponse> {
    private static final SdkField<String> ACCOUNT_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountAssociationId").getter(GetAccountAssociationResponse.getter(GetAccountAssociationResponse::accountAssociationId)).setter(GetAccountAssociationResponse.setter(Builder::accountAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssociationId").build()}).build();
    private static final SdkField<String> ASSOCIATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationState").getter(GetAccountAssociationResponse.getter(GetAccountAssociationResponse::associationStateAsString)).setter(GetAccountAssociationResponse.setter(Builder::associationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationState").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(GetAccountAssociationResponse.getter(GetAccountAssociationResponse::errorMessage)).setter(GetAccountAssociationResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> CONNECTOR_DESTINATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorDestinationId").getter(GetAccountAssociationResponse.getter(GetAccountAssociationResponse::connectorDestinationId)).setter(GetAccountAssociationResponse.setter(Builder::connectorDestinationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDestinationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetAccountAssociationResponse.getter(GetAccountAssociationResponse::name)).setter(GetAccountAssociationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetAccountAssociationResponse.getter(GetAccountAssociationResponse::description)).setter(GetAccountAssociationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetAccountAssociationResponse.getter(GetAccountAssociationResponse::arn)).setter(GetAccountAssociationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> O_AUTH_AUTHORIZATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OAuthAuthorizationUrl").getter(GetAccountAssociationResponse.getter(GetAccountAssociationResponse::oAuthAuthorizationUrl)).setter(GetAccountAssociationResponse.setter(Builder::oAuthAuthorizationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthAuthorizationUrl").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetAccountAssociationResponse.getter(GetAccountAssociationResponse::tags)).setter(GetAccountAssociationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ASSOCIATION_ID_FIELD, ASSOCIATION_STATE_FIELD, ERROR_MESSAGE_FIELD, CONNECTOR_DESTINATION_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ARN_FIELD, O_AUTH_AUTHORIZATION_URL_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAccountAssociationResponse.memberNameToFieldInitializer();
    private final String accountAssociationId;
    private final String associationState;
    private final String errorMessage;
    private final String connectorDestinationId;
    private final String name;
    private final String description;
    private final String arn;
    private final String oAuthAuthorizationUrl;
    private final Map<String, String> tags;

    private GetAccountAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.accountAssociationId = builder.accountAssociationId;
        this.associationState = builder.associationState;
        this.errorMessage = builder.errorMessage;
        this.connectorDestinationId = builder.connectorDestinationId;
        this.name = builder.name;
        this.description = builder.description;
        this.arn = builder.arn;
        this.oAuthAuthorizationUrl = builder.oAuthAuthorizationUrl;
        this.tags = builder.tags;
    }

    public final String accountAssociationId() {
        return this.accountAssociationId;
    }

    public final AssociationState associationState() {
        return AssociationState.fromValue(this.associationState);
    }

    public final String associationStateAsString() {
        return this.associationState;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String connectorDestinationId() {
        return this.connectorDestinationId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String arn() {
        return this.arn;
    }

    public final String oAuthAuthorizationUrl() {
        return this.oAuthAuthorizationUrl;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorDestinationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthAuthorizationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountAssociationResponse)) {
            return false;
        }
        GetAccountAssociationResponse other = (GetAccountAssociationResponse)((Object)obj);
        return Objects.equals(this.accountAssociationId(), other.accountAssociationId()) && Objects.equals(this.associationStateAsString(), other.associationStateAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.connectorDestinationId(), other.connectorDestinationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.oAuthAuthorizationUrl(), other.oAuthAuthorizationUrl()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccountAssociationResponse").add("AccountAssociationId", (Object)this.accountAssociationId()).add("AssociationState", (Object)this.associationStateAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("ConnectorDestinationId", (Object)this.connectorDestinationId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Arn", (Object)this.arn()).add("OAuthAuthorizationUrl", (Object)(this.oAuthAuthorizationUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountAssociationId": {
                return Optional.ofNullable(clazz.cast(this.accountAssociationId()));
            }
            case "AssociationState": {
                return Optional.ofNullable(clazz.cast(this.associationStateAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "ConnectorDestinationId": {
                return Optional.ofNullable(clazz.cast(this.connectorDestinationId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "OAuthAuthorizationUrl": {
                return Optional.ofNullable(clazz.cast(this.oAuthAuthorizationUrl()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountAssociationId", ACCOUNT_ASSOCIATION_ID_FIELD);
        map.put("AssociationState", ASSOCIATION_STATE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("ConnectorDestinationId", CONNECTOR_DESTINATION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("OAuthAuthorizationUrl", O_AUTH_AUTHORIZATION_URL_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccountAssociationResponse, T> g) {
        return obj -> g.apply((GetAccountAssociationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private String accountAssociationId;
        private String associationState;
        private String errorMessage;
        private String connectorDestinationId;
        private String name;
        private String description;
        private String arn;
        private String oAuthAuthorizationUrl;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountAssociationResponse model) {
            super(model);
            this.accountAssociationId(model.accountAssociationId);
            this.associationState(model.associationState);
            this.errorMessage(model.errorMessage);
            this.connectorDestinationId(model.connectorDestinationId);
            this.name(model.name);
            this.description(model.description);
            this.arn(model.arn);
            this.oAuthAuthorizationUrl(model.oAuthAuthorizationUrl);
            this.tags(model.tags);
        }

        public final String getAccountAssociationId() {
            return this.accountAssociationId;
        }

        public final void setAccountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
        }

        @Override
        public final Builder accountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
            return this;
        }

        public final String getAssociationState() {
            return this.associationState;
        }

        public final void setAssociationState(String associationState) {
            this.associationState = associationState;
        }

        @Override
        public final Builder associationState(String associationState) {
            this.associationState = associationState;
            return this;
        }

        @Override
        public final Builder associationState(AssociationState associationState) {
            this.associationState(associationState == null ? null : associationState.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getConnectorDestinationId() {
            return this.connectorDestinationId;
        }

        public final void setConnectorDestinationId(String connectorDestinationId) {
            this.connectorDestinationId = connectorDestinationId;
        }

        @Override
        public final Builder connectorDestinationId(String connectorDestinationId) {
            this.connectorDestinationId = connectorDestinationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getOAuthAuthorizationUrl() {
            return this.oAuthAuthorizationUrl;
        }

        public final void setOAuthAuthorizationUrl(String oAuthAuthorizationUrl) {
            this.oAuthAuthorizationUrl = oAuthAuthorizationUrl;
        }

        @Override
        public final Builder oAuthAuthorizationUrl(String oAuthAuthorizationUrl) {
            this.oAuthAuthorizationUrl = oAuthAuthorizationUrl;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetAccountAssociationResponse build() {
            return new GetAccountAssociationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccountAssociationResponse> {
        public Builder accountAssociationId(String var1);

        public Builder associationState(String var1);

        public Builder associationState(AssociationState var1);

        public Builder errorMessage(String var1);

        public Builder connectorDestinationId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder arn(String var1);

        public Builder oAuthAuthorizationUrl(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

