/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotjobsdataplane.model.IotJobsDataPlaneResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateJobExecutionResponse
extends IotJobsDataPlaneResponse
implements ToCopyableBuilder<Builder, UpdateJobExecutionResponse> {
    private static final SdkField<JobExecutionState> EXECUTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateJobExecutionResponse.getter(UpdateJobExecutionResponse::executionState)).setter(UpdateJobExecutionResponse.setter(Builder::executionState)).constructor(JobExecutionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionState").build()}).build();
    private static final SdkField<String> JOB_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateJobExecutionResponse.getter(UpdateJobExecutionResponse::jobDocument)).setter(UpdateJobExecutionResponse.setter(Builder::jobDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_STATE_FIELD, JOB_DOCUMENT_FIELD));
    private final JobExecutionState executionState;
    private final String jobDocument;

    private UpdateJobExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionState = builder.executionState;
        this.jobDocument = builder.jobDocument;
    }

    public JobExecutionState executionState() {
        return this.executionState;
    }

    public String jobDocument() {
        return this.jobDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDocument());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobExecutionResponse)) {
            return false;
        }
        UpdateJobExecutionResponse other = (UpdateJobExecutionResponse)((Object)obj);
        return Objects.equals(this.executionState(), other.executionState()) && Objects.equals(this.jobDocument(), other.jobDocument());
    }

    public String toString() {
        return ToString.builder((String)"UpdateJobExecutionResponse").add("ExecutionState", (Object)this.executionState()).add("JobDocument", (Object)this.jobDocument()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionState": {
                return Optional.ofNullable(clazz.cast(this.executionState()));
            }
            case "jobDocument": {
                return Optional.ofNullable(clazz.cast(this.jobDocument()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobExecutionResponse, T> g) {
        return obj -> g.apply((UpdateJobExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotJobsDataPlaneResponse.BuilderImpl
    implements Builder {
        private JobExecutionState executionState;
        private String jobDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobExecutionResponse model) {
            super(model);
            this.executionState(model.executionState);
            this.jobDocument(model.jobDocument);
        }

        public final JobExecutionState.Builder getExecutionState() {
            return this.executionState != null ? this.executionState.toBuilder() : null;
        }

        @Override
        public final Builder executionState(JobExecutionState executionState) {
            this.executionState = executionState;
            return this;
        }

        public final void setExecutionState(JobExecutionState.BuilderImpl executionState) {
            this.executionState = executionState != null ? executionState.build() : null;
        }

        public final String getJobDocument() {
            return this.jobDocument;
        }

        @Override
        public final Builder jobDocument(String jobDocument) {
            this.jobDocument = jobDocument;
            return this;
        }

        public final void setJobDocument(String jobDocument) {
            this.jobDocument = jobDocument;
        }

        @Override
        public UpdateJobExecutionResponse build() {
            return new UpdateJobExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotJobsDataPlaneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateJobExecutionResponse> {
        public Builder executionState(JobExecutionState var1);

        default public Builder executionState(Consumer<JobExecutionState.Builder> executionState) {
            return this.executionState((JobExecutionState)((JobExecutionState.Builder)JobExecutionState.builder().applyMutation(executionState)).build());
        }

        public Builder jobDocument(String var1);
    }
}

