/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotjobsdataplane.model.DetailsMapCopier;
import software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobExecution> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(JobExecution.getter(JobExecution::jobId)).setter(JobExecution.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(JobExecution.getter(JobExecution::thingName)).setter(JobExecution.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(JobExecution.getter(JobExecution::statusAsString)).setter(JobExecution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("statusDetails").getter(JobExecution.getter(JobExecution::statusDetails)).setter(JobExecution.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> QUEUED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("queuedAt").getter(JobExecution.getter(JobExecution::queuedAt)).setter(JobExecution.setter(Builder::queuedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedAt").build()}).build();
    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startedAt").getter(JobExecution.getter(JobExecution::startedAt)).setter(JobExecution.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Long> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastUpdatedAt").getter(JobExecution.getter(JobExecution::lastUpdatedAt)).setter(JobExecution.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<Long> APPROXIMATE_SECONDS_BEFORE_TIMED_OUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("approximateSecondsBeforeTimedOut").getter(JobExecution.getter(JobExecution::approximateSecondsBeforeTimedOut)).setter(JobExecution.setter(Builder::approximateSecondsBeforeTimedOut)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approximateSecondsBeforeTimedOut").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("versionNumber").getter(JobExecution.getter(JobExecution::versionNumber)).setter(JobExecution.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()}).build();
    private static final SdkField<Long> EXECUTION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("executionNumber").getter(JobExecution.getter(JobExecution::executionNumber)).setter(JobExecution.setter(Builder::executionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionNumber").build()}).build();
    private static final SdkField<String> JOB_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobDocument").getter(JobExecution.getter(JobExecution::jobDocument)).setter(JobExecution.setter(Builder::jobDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, THING_NAME_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, QUEUED_AT_FIELD, STARTED_AT_FIELD, LAST_UPDATED_AT_FIELD, APPROXIMATE_SECONDS_BEFORE_TIMED_OUT_FIELD, VERSION_NUMBER_FIELD, EXECUTION_NUMBER_FIELD, JOB_DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobExecution.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String thingName;
    private final String status;
    private final Map<String, String> statusDetails;
    private final Long queuedAt;
    private final Long startedAt;
    private final Long lastUpdatedAt;
    private final Long approximateSecondsBeforeTimedOut;
    private final Long versionNumber;
    private final Long executionNumber;
    private final String jobDocument;

    private JobExecution(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.thingName = builder.thingName;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.queuedAt = builder.queuedAt;
        this.startedAt = builder.startedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.approximateSecondsBeforeTimedOut = builder.approximateSecondsBeforeTimedOut;
        this.versionNumber = builder.versionNumber;
        this.executionNumber = builder.executionNumber;
        this.jobDocument = builder.jobDocument;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String thingName() {
        return this.thingName;
    }

    public final JobExecutionStatus status() {
        return JobExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasStatusDetails() {
        return this.statusDetails != null && !(this.statusDetails instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> statusDetails() {
        return this.statusDetails;
    }

    public final Long queuedAt() {
        return this.queuedAt;
    }

    public final Long startedAt() {
        return this.startedAt;
    }

    public final Long lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Long approximateSecondsBeforeTimedOut() {
        return this.approximateSecondsBeforeTimedOut;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    public final Long executionNumber() {
        return this.executionNumber;
    }

    public final String jobDocument() {
        return this.jobDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusDetails() ? this.statusDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateSecondsBeforeTimedOut());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecution)) {
            return false;
        }
        JobExecution other = (JobExecution)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasStatusDetails() == other.hasStatusDetails() && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.queuedAt(), other.queuedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.approximateSecondsBeforeTimedOut(), other.approximateSecondsBeforeTimedOut()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.executionNumber(), other.executionNumber()) && Objects.equals(this.jobDocument(), other.jobDocument());
    }

    public final String toString() {
        return ToString.builder((String)"JobExecution").add("JobId", (Object)this.jobId()).add("ThingName", (Object)this.thingName()).add("Status", (Object)this.statusAsString()).add("StatusDetails", this.hasStatusDetails() ? this.statusDetails() : null).add("QueuedAt", (Object)this.queuedAt()).add("StartedAt", (Object)this.startedAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("ApproximateSecondsBeforeTimedOut", (Object)this.approximateSecondsBeforeTimedOut()).add("VersionNumber", (Object)this.versionNumber()).add("ExecutionNumber", (Object)this.executionNumber()).add("JobDocument", (Object)this.jobDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "queuedAt": {
                return Optional.ofNullable(clazz.cast(this.queuedAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "approximateSecondsBeforeTimedOut": {
                return Optional.ofNullable(clazz.cast(this.approximateSecondsBeforeTimedOut()));
            }
            case "versionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "executionNumber": {
                return Optional.ofNullable(clazz.cast(this.executionNumber()));
            }
            case "jobDocument": {
                return Optional.ofNullable(clazz.cast(this.jobDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("thingName", THING_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusDetails", STATUS_DETAILS_FIELD);
        map.put("queuedAt", QUEUED_AT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("approximateSecondsBeforeTimedOut", APPROXIMATE_SECONDS_BEFORE_TIMED_OUT_FIELD);
        map.put("versionNumber", VERSION_NUMBER_FIELD);
        map.put("executionNumber", EXECUTION_NUMBER_FIELD);
        map.put("jobDocument", JOB_DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobExecution, T> g) {
        return obj -> g.apply((JobExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String thingName;
        private String status;
        private Map<String, String> statusDetails = DefaultSdkAutoConstructMap.getInstance();
        private Long queuedAt;
        private Long startedAt;
        private Long lastUpdatedAt;
        private Long approximateSecondsBeforeTimedOut;
        private Long versionNumber;
        private Long executionNumber;
        private String jobDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecution model) {
            this.jobId(model.jobId);
            this.thingName(model.thingName);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.queuedAt(model.queuedAt);
            this.startedAt(model.startedAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.approximateSecondsBeforeTimedOut(model.approximateSecondsBeforeTimedOut);
            this.versionNumber(model.versionNumber);
            this.executionNumber(model.executionNumber);
            this.jobDocument(model.jobDocument);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getThingName() {
            return this.thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getStatusDetails() {
            if (this.statusDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.statusDetails;
        }

        public final void setStatusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
        }

        @Override
        public final Builder statusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
            return this;
        }

        public final Long getQueuedAt() {
            return this.queuedAt;
        }

        public final void setQueuedAt(Long queuedAt) {
            this.queuedAt = queuedAt;
        }

        @Override
        public final Builder queuedAt(Long queuedAt) {
            this.queuedAt = queuedAt;
            return this;
        }

        public final Long getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Long getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Long lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Long lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Long getApproximateSecondsBeforeTimedOut() {
            return this.approximateSecondsBeforeTimedOut;
        }

        public final void setApproximateSecondsBeforeTimedOut(Long approximateSecondsBeforeTimedOut) {
            this.approximateSecondsBeforeTimedOut = approximateSecondsBeforeTimedOut;
        }

        @Override
        public final Builder approximateSecondsBeforeTimedOut(Long approximateSecondsBeforeTimedOut) {
            this.approximateSecondsBeforeTimedOut = approximateSecondsBeforeTimedOut;
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final Long getExecutionNumber() {
            return this.executionNumber;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        @Override
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final String getJobDocument() {
            return this.jobDocument;
        }

        public final void setJobDocument(String jobDocument) {
            this.jobDocument = jobDocument;
        }

        @Override
        public final Builder jobDocument(String jobDocument) {
            this.jobDocument = jobDocument;
            return this;
        }

        public JobExecution build() {
            return new JobExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobExecution> {
        public Builder jobId(String var1);

        public Builder thingName(String var1);

        public Builder status(String var1);

        public Builder status(JobExecutionStatus var1);

        public Builder statusDetails(Map<String, String> var1);

        public Builder queuedAt(Long var1);

        public Builder startedAt(Long var1);

        public Builder lastUpdatedAt(Long var1);

        public Builder approximateSecondsBeforeTimedOut(Long var1);

        public Builder versionNumber(Long var1);

        public Builder executionNumber(Long var1);

        public Builder jobDocument(String var1);
    }
}

