/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotjobsdataplane;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotjobsdataplane.DefaultIotJobsDataPlaneAsyncClient;
import software.amazon.awssdk.services.iotjobsdataplane.DefaultIotJobsDataPlaneBaseClientBuilder;
import software.amazon.awssdk.services.iotjobsdataplane.IotJobsDataPlaneAsyncClient;
import software.amazon.awssdk.services.iotjobsdataplane.IotJobsDataPlaneAsyncClientBuilder;
import software.amazon.awssdk.services.iotjobsdataplane.IotJobsDataPlaneServiceClientConfiguration;
import software.amazon.awssdk.services.iotjobsdataplane.endpoints.IotJobsDataPlaneEndpointProvider;

@SdkInternalApi
final class DefaultIotJobsDataPlaneAsyncClientBuilder
extends DefaultIotJobsDataPlaneBaseClientBuilder<IotJobsDataPlaneAsyncClientBuilder, IotJobsDataPlaneAsyncClient>
implements IotJobsDataPlaneAsyncClientBuilder {
    DefaultIotJobsDataPlaneAsyncClientBuilder() {
    }

    @Override
    public DefaultIotJobsDataPlaneAsyncClientBuilder endpointProvider(IotJobsDataPlaneEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotJobsDataPlaneAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIotJobsDataPlaneAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IotJobsDataPlaneServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIotJobsDataPlaneAsyncClient client = new DefaultIotJobsDataPlaneAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IotJobsDataPlaneServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IotJobsDataPlaneServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

