/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotjobsdataplane.model.DetailsMapCopier;
import software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobExecutionState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobExecutionState> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(JobExecutionState.getter(JobExecutionState::statusAsString)).setter(JobExecutionState.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("statusDetails").getter(JobExecutionState.getter(JobExecutionState::statusDetails)).setter(JobExecutionState.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("versionNumber").getter(JobExecutionState.getter(JobExecutionState::versionNumber)).setter(JobExecutionState.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, STATUS_DETAILS_FIELD, VERSION_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Map<String, String> statusDetails;
    private final Long versionNumber;

    private JobExecutionState(BuilderImpl builder) {
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.versionNumber = builder.versionNumber;
    }

    public JobExecutionStatus status() {
        return JobExecutionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public boolean hasStatusDetails() {
        return this.statusDetails != null && !(this.statusDetails instanceof SdkAutoConstructMap);
    }

    public Map<String, String> statusDetails() {
        return this.statusDetails;
    }

    public Long versionNumber() {
        return this.versionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusDetails() ? this.statusDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionState)) {
            return false;
        }
        JobExecutionState other = (JobExecutionState)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasStatusDetails() == other.hasStatusDetails() && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.versionNumber(), other.versionNumber());
    }

    public String toString() {
        return ToString.builder((String)"JobExecutionState").add("Status", (Object)this.statusAsString()).add("StatusDetails", this.hasStatusDetails() ? this.statusDetails() : null).add("VersionNumber", (Object)this.versionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "versionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionState, T> g) {
        return obj -> g.apply((JobExecutionState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Map<String, String> statusDetails = DefaultSdkAutoConstructMap.getInstance();
        private Long versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionState model) {
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.versionNumber(model.versionNumber);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Map<String, String> getStatusDetails() {
            if (this.statusDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
            return this;
        }

        public final void setStatusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public JobExecutionState build() {
            return new JobExecutionState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobExecutionState> {
        public Builder status(String var1);

        public Builder status(JobExecutionStatus var1);

        public Builder statusDetails(Map<String, String> var1);

        public Builder versionNumber(Long var1);
    }
}

