/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.LogType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchLogDeliveryOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchLogDeliveryOptions> {
    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logType").getter(CloudWatchLogDeliveryOptions.getter(CloudWatchLogDeliveryOptions::logTypeAsString)).setter(CloudWatchLogDeliveryOptions.setter(Builder::logType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logType").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(CloudWatchLogDeliveryOptions.getter(CloudWatchLogDeliveryOptions::logGroupName)).setter(CloudWatchLogDeliveryOptions.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPE_FIELD, LOG_GROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CloudWatchLogDeliveryOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String logType;
    private final String logGroupName;

    private CloudWatchLogDeliveryOptions(BuilderImpl builder) {
        this.logType = builder.logType;
        this.logGroupName = builder.logGroupName;
    }

    public final LogType logType() {
        return LogType.fromValue(this.logType);
    }

    public final String logTypeAsString() {
        return this.logType;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogDeliveryOptions)) {
            return false;
        }
        CloudWatchLogDeliveryOptions other = (CloudWatchLogDeliveryOptions)obj;
        return Objects.equals(this.logTypeAsString(), other.logTypeAsString()) && Objects.equals(this.logGroupName(), other.logGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchLogDeliveryOptions").add("LogType", (Object)this.logTypeAsString()).add("LogGroupName", (Object)this.logGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logType": {
                return Optional.ofNullable(clazz.cast(this.logTypeAsString()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("logType", LOG_TYPE_FIELD);
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogDeliveryOptions, T> g) {
        return obj -> g.apply((CloudWatchLogDeliveryOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logType;
        private String logGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogDeliveryOptions model) {
            this.logType(model.logType);
            this.logGroupName(model.logGroupName);
        }

        public final String getLogType() {
            return this.logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public CloudWatchLogDeliveryOptions build() {
            return new CloudWatchLogDeliveryOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchLogDeliveryOptions> {
        public Builder logType(String var1);

        public Builder logType(LogType var1);

        public Builder logGroupName(String var1);
    }
}

