/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.NetworkInterfaceFailureReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvalidNetworkInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvalidNetworkInterface> {
    private static final SdkField<String> INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interfaceId").getter(InvalidNetworkInterface.getter(InvalidNetworkInterface::interfaceId)).setter(InvalidNetworkInterface.setter(Builder::interfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceId").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(InvalidNetworkInterface.getter(InvalidNetworkInterface::reasonAsString)).setter(InvalidNetworkInterface.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERFACE_ID_FIELD, REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvalidNetworkInterface.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String interfaceId;
    private final String reason;

    private InvalidNetworkInterface(BuilderImpl builder) {
        this.interfaceId = builder.interfaceId;
        this.reason = builder.reason;
    }

    public final String interfaceId() {
        return this.interfaceId;
    }

    public final NetworkInterfaceFailureReason reason() {
        return NetworkInterfaceFailureReason.fromValue(this.reason);
    }

    public final String reasonAsString() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidNetworkInterface)) {
            return false;
        }
        InvalidNetworkInterface other = (InvalidNetworkInterface)obj;
        return Objects.equals(this.interfaceId(), other.interfaceId()) && Objects.equals(this.reasonAsString(), other.reasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InvalidNetworkInterface").add("InterfaceId", (Object)this.interfaceId()).add("Reason", (Object)this.reasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interfaceId": {
                return Optional.ofNullable(clazz.cast(this.interfaceId()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("interfaceId", INTERFACE_ID_FIELD);
        map.put("reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidNetworkInterface, T> g) {
        return obj -> g.apply((InvalidNetworkInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String interfaceId;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidNetworkInterface model) {
            this.interfaceId(model.interfaceId);
            this.reason(model.reason);
        }

        public final String getInterfaceId() {
            return this.interfaceId;
        }

        public final void setInterfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
        }

        @Override
        public final Builder interfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(NetworkInterfaceFailureReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public InvalidNetworkInterface build() {
            return new InvalidNetworkInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvalidNetworkInterface> {
        public Builder interfaceId(String var1);

        public Builder reason(String var1);

        public Builder reason(NetworkInterfaceFailureReason var1);
    }
}

