/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListResponseScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelManifestsRequest
extends IoTFleetWiseRequest
implements ToCopyableBuilder<Builder, ListModelManifestsRequest> {
    private static final SdkField<String> SIGNAL_CATALOG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signalCatalogArn").getter(ListModelManifestsRequest.getter(ListModelManifestsRequest::signalCatalogArn)).setter(ListModelManifestsRequest.setter(Builder::signalCatalogArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalCatalogArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListModelManifestsRequest.getter(ListModelManifestsRequest::nextToken)).setter(ListModelManifestsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListModelManifestsRequest.getter(ListModelManifestsRequest::maxResults)).setter(ListModelManifestsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> LIST_RESPONSE_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listResponseScope").getter(ListModelManifestsRequest.getter(ListModelManifestsRequest::listResponseScopeAsString)).setter(ListModelManifestsRequest.setter(Builder::listResponseScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listResponseScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNAL_CATALOG_ARN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LIST_RESPONSE_SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListModelManifestsRequest.memberNameToFieldInitializer();
    private final String signalCatalogArn;
    private final String nextToken;
    private final Integer maxResults;
    private final String listResponseScope;

    private ListModelManifestsRequest(BuilderImpl builder) {
        super(builder);
        this.signalCatalogArn = builder.signalCatalogArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.listResponseScope = builder.listResponseScope;
    }

    public final String signalCatalogArn() {
        return this.signalCatalogArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ListResponseScope listResponseScope() {
        return ListResponseScope.fromValue(this.listResponseScope);
    }

    public final String listResponseScopeAsString() {
        return this.listResponseScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.signalCatalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.listResponseScopeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelManifestsRequest)) {
            return false;
        }
        ListModelManifestsRequest other = (ListModelManifestsRequest)((Object)obj);
        return Objects.equals(this.signalCatalogArn(), other.signalCatalogArn()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.listResponseScopeAsString(), other.listResponseScopeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelManifestsRequest").add("SignalCatalogArn", (Object)this.signalCatalogArn()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ListResponseScope", (Object)this.listResponseScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signalCatalogArn": {
                return Optional.ofNullable(clazz.cast(this.signalCatalogArn()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "listResponseScope": {
                return Optional.ofNullable(clazz.cast(this.listResponseScopeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("signalCatalogArn", SIGNAL_CATALOG_ARN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("listResponseScope", LIST_RESPONSE_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelManifestsRequest, T> g) {
        return obj -> g.apply((ListModelManifestsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseRequest.BuilderImpl
    implements Builder {
        private String signalCatalogArn;
        private String nextToken;
        private Integer maxResults;
        private String listResponseScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelManifestsRequest model) {
            super(model);
            this.signalCatalogArn(model.signalCatalogArn);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.listResponseScope(model.listResponseScope);
        }

        public final String getSignalCatalogArn() {
            return this.signalCatalogArn;
        }

        public final void setSignalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
        }

        @Override
        public final Builder signalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getListResponseScope() {
            return this.listResponseScope;
        }

        public final void setListResponseScope(String listResponseScope) {
            this.listResponseScope = listResponseScope;
        }

        @Override
        public final Builder listResponseScope(String listResponseScope) {
            this.listResponseScope = listResponseScope;
            return this;
        }

        @Override
        public final Builder listResponseScope(ListResponseScope listResponseScope) {
            this.listResponseScope(listResponseScope == null ? null : listResponseScope.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListModelManifestsRequest build() {
            return new ListModelManifestsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTFleetWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelManifestsRequest> {
        public Builder signalCatalogArn(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder listResponseScope(String var1);

        public Builder listResponseScope(ListResponseScope var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

