/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseResponse;
import software.amazon.awssdk.services.iotfleetwise.model.VehicleSummary;
import software.amazon.awssdk.services.iotfleetwise.model._vehicleSummariesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVehiclesResponse
extends IoTFleetWiseResponse
implements ToCopyableBuilder<Builder, ListVehiclesResponse> {
    private static final SdkField<List<VehicleSummary>> VEHICLE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vehicleSummaries").getter(ListVehiclesResponse.getter(ListVehiclesResponse::vehicleSummaries)).setter(ListVehiclesResponse.setter(Builder::vehicleSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicleSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VehicleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListVehiclesResponse.getter(ListVehiclesResponse::nextToken)).setter(ListVehiclesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVehiclesResponse.memberNameToFieldInitializer();
    private final List<VehicleSummary> vehicleSummaries;
    private final String nextToken;

    private ListVehiclesResponse(BuilderImpl builder) {
        super(builder);
        this.vehicleSummaries = builder.vehicleSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVehicleSummaries() {
        return this.vehicleSummaries != null && !(this.vehicleSummaries instanceof SdkAutoConstructList);
    }

    public final List<VehicleSummary> vehicleSummaries() {
        return this.vehicleSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVehicleSummaries() ? this.vehicleSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVehiclesResponse)) {
            return false;
        }
        ListVehiclesResponse other = (ListVehiclesResponse)((Object)obj);
        return this.hasVehicleSummaries() == other.hasVehicleSummaries() && Objects.equals(this.vehicleSummaries(), other.vehicleSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListVehiclesResponse").add("VehicleSummaries", this.hasVehicleSummaries() ? this.vehicleSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vehicleSummaries": {
                return Optional.ofNullable(clazz.cast(this.vehicleSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vehicleSummaries", VEHICLE_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVehiclesResponse, T> g) {
        return obj -> g.apply((ListVehiclesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseResponse.BuilderImpl
    implements Builder {
        private List<VehicleSummary> vehicleSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVehiclesResponse model) {
            super(model);
            this.vehicleSummaries(model.vehicleSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<VehicleSummary.Builder> getVehicleSummaries() {
            List<VehicleSummary.Builder> result = _vehicleSummariesCopier.copyToBuilder(this.vehicleSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVehicleSummaries(Collection<VehicleSummary.BuilderImpl> vehicleSummaries) {
            this.vehicleSummaries = _vehicleSummariesCopier.copyFromBuilder(vehicleSummaries);
        }

        @Override
        public final Builder vehicleSummaries(Collection<VehicleSummary> vehicleSummaries) {
            this.vehicleSummaries = _vehicleSummariesCopier.copy(vehicleSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vehicleSummaries(VehicleSummary ... vehicleSummaries) {
            this.vehicleSummaries(Arrays.asList(vehicleSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vehicleSummaries(Consumer<VehicleSummary.Builder> ... vehicleSummaries) {
            this.vehicleSummaries(Stream.of(vehicleSummaries).map(c -> (VehicleSummary)((VehicleSummary.Builder)VehicleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVehiclesResponse build() {
            return new ListVehiclesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTFleetWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVehiclesResponse> {
        public Builder vehicleSummaries(Collection<VehicleSummary> var1);

        public Builder vehicleSummaries(VehicleSummary ... var1);

        public Builder vehicleSummaries(Consumer<VehicleSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

