/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.VehicleSummary;

public class ListVehiclesIterable
implements SdkIterable<ListVehiclesResponse> {
    private final IoTFleetWiseClient client;
    private final ListVehiclesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVehiclesIterable(IoTFleetWiseClient client, ListVehiclesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVehiclesResponseFetcher();
    }

    public Iterator<ListVehiclesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VehicleSummary> vehicleSummaries() {
        Function<ListVehiclesResponse, Iterator> getIterator = response -> {
            if (response != null && response.vehicleSummaries() != null) {
                return response.vehicleSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVehiclesResponseFetcher
    implements SyncPageFetcher<ListVehiclesResponse> {
        private ListVehiclesResponseFetcher() {
        }

        public boolean hasNextPage(ListVehiclesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVehiclesResponse nextPage(ListVehiclesResponse previousPage) {
            if (previousPage == null) {
                return ListVehiclesIterable.this.client.listVehicles(ListVehiclesIterable.this.firstRequest);
            }
            return ListVehiclesIterable.this.client.listVehicles((ListVehiclesRequest)((Object)ListVehiclesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

