/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotfleetwise.model.MqttTopicConfig;
import software.amazon.awssdk.services.iotfleetwise.model.S3Config;
import software.amazon.awssdk.services.iotfleetwise.model.TimestreamConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataDestinationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataDestinationConfig> {
    private static final SdkField<S3Config> S3_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Config").getter(DataDestinationConfig.getter(DataDestinationConfig::s3Config)).setter(DataDestinationConfig.setter(Builder::s3Config)).constructor(S3Config::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Config").build()}).build();
    private static final SdkField<TimestreamConfig> TIMESTREAM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timestreamConfig").getter(DataDestinationConfig.getter(DataDestinationConfig::timestreamConfig)).setter(DataDestinationConfig.setter(Builder::timestreamConfig)).constructor(TimestreamConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestreamConfig").build()}).build();
    private static final SdkField<MqttTopicConfig> MQTT_TOPIC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mqttTopicConfig").getter(DataDestinationConfig.getter(DataDestinationConfig::mqttTopicConfig)).setter(DataDestinationConfig.setter(Builder::mqttTopicConfig)).constructor(MqttTopicConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mqttTopicConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_CONFIG_FIELD, TIMESTREAM_CONFIG_FIELD, MQTT_TOPIC_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("s3Config", S3_CONFIG_FIELD);
            this.put("timestreamConfig", TIMESTREAM_CONFIG_FIELD);
            this.put("mqttTopicConfig", MQTT_TOPIC_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final S3Config s3Config;
    private final TimestreamConfig timestreamConfig;
    private final MqttTopicConfig mqttTopicConfig;
    private final Type type;

    private DataDestinationConfig(BuilderImpl builder) {
        this.s3Config = builder.s3Config;
        this.timestreamConfig = builder.timestreamConfig;
        this.mqttTopicConfig = builder.mqttTopicConfig;
        this.type = builder.type;
    }

    public final S3Config s3Config() {
        return this.s3Config;
    }

    public final TimestreamConfig timestreamConfig() {
        return this.timestreamConfig;
    }

    public final MqttTopicConfig mqttTopicConfig() {
        return this.mqttTopicConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Config());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestreamConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.mqttTopicConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataDestinationConfig)) {
            return false;
        }
        DataDestinationConfig other = (DataDestinationConfig)obj;
        return Objects.equals(this.s3Config(), other.s3Config()) && Objects.equals(this.timestreamConfig(), other.timestreamConfig()) && Objects.equals(this.mqttTopicConfig(), other.mqttTopicConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DataDestinationConfig").add("S3Config", (Object)this.s3Config()).add("TimestreamConfig", (Object)this.timestreamConfig()).add("MqttTopicConfig", (Object)this.mqttTopicConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Config": {
                return Optional.ofNullable(clazz.cast(this.s3Config()));
            }
            case "timestreamConfig": {
                return Optional.ofNullable(clazz.cast(this.timestreamConfig()));
            }
            case "mqttTopicConfig": {
                return Optional.ofNullable(clazz.cast(this.mqttTopicConfig()));
            }
        }
        return Optional.empty();
    }

    public static DataDestinationConfig fromS3Config(S3Config s3Config) {
        return (DataDestinationConfig)DataDestinationConfig.builder().s3Config(s3Config).build();
    }

    public static DataDestinationConfig fromS3Config(Consumer<S3Config.Builder> s3Config) {
        S3Config.Builder builder = S3Config.builder();
        s3Config.accept(builder);
        return DataDestinationConfig.fromS3Config((S3Config)builder.build());
    }

    public static DataDestinationConfig fromTimestreamConfig(TimestreamConfig timestreamConfig) {
        return (DataDestinationConfig)DataDestinationConfig.builder().timestreamConfig(timestreamConfig).build();
    }

    public static DataDestinationConfig fromTimestreamConfig(Consumer<TimestreamConfig.Builder> timestreamConfig) {
        TimestreamConfig.Builder builder = TimestreamConfig.builder();
        timestreamConfig.accept(builder);
        return DataDestinationConfig.fromTimestreamConfig((TimestreamConfig)builder.build());
    }

    public static DataDestinationConfig fromMqttTopicConfig(MqttTopicConfig mqttTopicConfig) {
        return (DataDestinationConfig)DataDestinationConfig.builder().mqttTopicConfig(mqttTopicConfig).build();
    }

    public static DataDestinationConfig fromMqttTopicConfig(Consumer<MqttTopicConfig.Builder> mqttTopicConfig) {
        MqttTopicConfig.Builder builder = MqttTopicConfig.builder();
        mqttTopicConfig.accept(builder);
        return DataDestinationConfig.fromMqttTopicConfig((MqttTopicConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataDestinationConfig, T> g) {
        return obj -> g.apply((DataDestinationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3_CONFIG,
        TIMESTREAM_CONFIG,
        MQTT_TOPIC_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private S3Config s3Config;
        private TimestreamConfig timestreamConfig;
        private MqttTopicConfig mqttTopicConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataDestinationConfig model) {
            this.s3Config(model.s3Config);
            this.timestreamConfig(model.timestreamConfig);
            this.mqttTopicConfig(model.mqttTopicConfig);
        }

        public final S3Config.Builder getS3Config() {
            return this.s3Config != null ? this.s3Config.toBuilder() : null;
        }

        public final void setS3Config(S3Config.BuilderImpl s3Config) {
            S3Config oldValue = this.s3Config;
            this.s3Config = s3Config != null ? s3Config.build() : null;
            this.handleUnionValueChange(Type.S3_CONFIG, oldValue, this.s3Config);
        }

        @Override
        public final Builder s3Config(S3Config s3Config) {
            S3Config oldValue = this.s3Config;
            this.s3Config = s3Config;
            this.handleUnionValueChange(Type.S3_CONFIG, oldValue, this.s3Config);
            return this;
        }

        public final TimestreamConfig.Builder getTimestreamConfig() {
            return this.timestreamConfig != null ? this.timestreamConfig.toBuilder() : null;
        }

        public final void setTimestreamConfig(TimestreamConfig.BuilderImpl timestreamConfig) {
            TimestreamConfig oldValue = this.timestreamConfig;
            this.timestreamConfig = timestreamConfig != null ? timestreamConfig.build() : null;
            this.handleUnionValueChange(Type.TIMESTREAM_CONFIG, oldValue, this.timestreamConfig);
        }

        @Override
        public final Builder timestreamConfig(TimestreamConfig timestreamConfig) {
            TimestreamConfig oldValue = this.timestreamConfig;
            this.timestreamConfig = timestreamConfig;
            this.handleUnionValueChange(Type.TIMESTREAM_CONFIG, oldValue, this.timestreamConfig);
            return this;
        }

        public final MqttTopicConfig.Builder getMqttTopicConfig() {
            return this.mqttTopicConfig != null ? this.mqttTopicConfig.toBuilder() : null;
        }

        public final void setMqttTopicConfig(MqttTopicConfig.BuilderImpl mqttTopicConfig) {
            MqttTopicConfig oldValue = this.mqttTopicConfig;
            this.mqttTopicConfig = mqttTopicConfig != null ? mqttTopicConfig.build() : null;
            this.handleUnionValueChange(Type.MQTT_TOPIC_CONFIG, oldValue, this.mqttTopicConfig);
        }

        @Override
        public final Builder mqttTopicConfig(MqttTopicConfig mqttTopicConfig) {
            MqttTopicConfig oldValue = this.mqttTopicConfig;
            this.mqttTopicConfig = mqttTopicConfig;
            this.handleUnionValueChange(Type.MQTT_TOPIC_CONFIG, oldValue, this.mqttTopicConfig);
            return this;
        }

        public DataDestinationConfig build() {
            return new DataDestinationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataDestinationConfig> {
        public Builder s3Config(S3Config var1);

        default public Builder s3Config(Consumer<S3Config.Builder> s3Config) {
            return this.s3Config((S3Config)((S3Config.Builder)S3Config.builder().applyMutation(s3Config)).build());
        }

        public Builder timestreamConfig(TimestreamConfig var1);

        default public Builder timestreamConfig(Consumer<TimestreamConfig.Builder> timestreamConfig) {
            return this.timestreamConfig((TimestreamConfig)((TimestreamConfig.Builder)TimestreamConfig.builder().applyMutation(timestreamConfig)).build());
        }

        public Builder mqttTopicConfig(MqttTopicConfig var1);

        default public Builder mqttTopicConfig(Consumer<MqttTopicConfig.Builder> mqttTopicConfig) {
            return this.mqttTopicConfig((MqttTopicConfig)((MqttTopicConfig.Builder)MqttTopicConfig.builder().applyMutation(mqttTopicConfig)).build());
        }
    }
}

