/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseAsyncClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse;

public class ListVehiclesInFleetPublisher
implements SdkPublisher<ListVehiclesInFleetResponse> {
    private final IoTFleetWiseAsyncClient client;
    private final ListVehiclesInFleetRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVehiclesInFleetPublisher(IoTFleetWiseAsyncClient client, ListVehiclesInFleetRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVehiclesInFleetPublisher(IoTFleetWiseAsyncClient client, ListVehiclesInFleetRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVehiclesInFleetResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVehiclesInFleetResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> vehicles() {
        Function<ListVehiclesInFleetResponse, Iterator> getIterator = response -> {
            if (response != null && response.vehicles() != null) {
                return response.vehicles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVehiclesInFleetResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVehiclesInFleetResponseFetcher
    implements AsyncPageFetcher<ListVehiclesInFleetResponse> {
        private ListVehiclesInFleetResponseFetcher() {
        }

        public boolean hasNextPage(ListVehiclesInFleetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVehiclesInFleetResponse> nextPage(ListVehiclesInFleetResponse previousPage) {
            if (previousPage == null) {
                return ListVehiclesInFleetPublisher.this.client.listVehiclesInFleet(ListVehiclesInFleetPublisher.this.firstRequest);
            }
            return ListVehiclesInFleetPublisher.this.client.listVehiclesInFleet((ListVehiclesInFleetRequest)((Object)ListVehiclesInFleetPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

