/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.CampaignStatus;
import software.amazon.awssdk.services.iotfleetwise.model.CollectionScheme;
import software.amazon.awssdk.services.iotfleetwise.model.Compression;
import software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig;
import software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfigsCopier;
import software.amazon.awssdk.services.iotfleetwise.model.DataExtraDimensionNodePathListCopier;
import software.amazon.awssdk.services.iotfleetwise.model.DiagnosticsMode;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseResponse;
import software.amazon.awssdk.services.iotfleetwise.model.SignalInformation;
import software.amazon.awssdk.services.iotfleetwise.model.SignalInformationListCopier;
import software.amazon.awssdk.services.iotfleetwise.model.SpoolingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCampaignResponse
extends IoTFleetWiseResponse
implements ToCopyableBuilder<Builder, GetCampaignResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetCampaignResponse.getter(GetCampaignResponse::name)).setter(GetCampaignResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetCampaignResponse.getter(GetCampaignResponse::arn)).setter(GetCampaignResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetCampaignResponse.getter(GetCampaignResponse::description)).setter(GetCampaignResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SIGNAL_CATALOG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signalCatalogArn").getter(GetCampaignResponse.getter(GetCampaignResponse::signalCatalogArn)).setter(GetCampaignResponse.setter(Builder::signalCatalogArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalCatalogArn").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(GetCampaignResponse.getter(GetCampaignResponse::targetArn)).setter(GetCampaignResponse.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetCampaignResponse.getter(GetCampaignResponse::statusAsString)).setter(GetCampaignResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetCampaignResponse.getter(GetCampaignResponse::startTime)).setter(GetCampaignResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> EXPIRY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiryTime").getter(GetCampaignResponse.getter(GetCampaignResponse::expiryTime)).setter(GetCampaignResponse.setter(Builder::expiryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiryTime").build()}).build();
    private static final SdkField<Long> POST_TRIGGER_COLLECTION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("postTriggerCollectionDuration").getter(GetCampaignResponse.getter(GetCampaignResponse::postTriggerCollectionDuration)).setter(GetCampaignResponse.setter(Builder::postTriggerCollectionDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postTriggerCollectionDuration").build()}).build();
    private static final SdkField<String> DIAGNOSTICS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("diagnosticsMode").getter(GetCampaignResponse.getter(GetCampaignResponse::diagnosticsModeAsString)).setter(GetCampaignResponse.setter(Builder::diagnosticsMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diagnosticsMode").build()}).build();
    private static final SdkField<String> SPOOLING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spoolingMode").getter(GetCampaignResponse.getter(GetCampaignResponse::spoolingModeAsString)).setter(GetCampaignResponse.setter(Builder::spoolingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spoolingMode").build()}).build();
    private static final SdkField<String> COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("compression").getter(GetCampaignResponse.getter(GetCampaignResponse::compressionAsString)).setter(GetCampaignResponse.setter(Builder::compression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compression").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(GetCampaignResponse.getter(GetCampaignResponse::priority)).setter(GetCampaignResponse.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<List<SignalInformation>> SIGNALS_TO_COLLECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("signalsToCollect").getter(GetCampaignResponse.getter(GetCampaignResponse::signalsToCollect)).setter(GetCampaignResponse.setter(Builder::signalsToCollect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalsToCollect").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SignalInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CollectionScheme> COLLECTION_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("collectionScheme").getter(GetCampaignResponse.getter(GetCampaignResponse::collectionScheme)).setter(GetCampaignResponse.setter(Builder::collectionScheme)).constructor(CollectionScheme::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionScheme").build()}).build();
    private static final SdkField<List<String>> DATA_EXTRA_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataExtraDimensions").getter(GetCampaignResponse.getter(GetCampaignResponse::dataExtraDimensions)).setter(GetCampaignResponse.setter(Builder::dataExtraDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataExtraDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetCampaignResponse.getter(GetCampaignResponse::creationTime)).setter(GetCampaignResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModificationTime").getter(GetCampaignResponse.getter(GetCampaignResponse::lastModificationTime)).setter(GetCampaignResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModificationTime").build()}).build();
    private static final SdkField<List<DataDestinationConfig>> DATA_DESTINATION_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataDestinationConfigs").getter(GetCampaignResponse.getter(GetCampaignResponse::dataDestinationConfigs)).setter(GetCampaignResponse.setter(Builder::dataDestinationConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDestinationConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataDestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, DESCRIPTION_FIELD, SIGNAL_CATALOG_ARN_FIELD, TARGET_ARN_FIELD, STATUS_FIELD, START_TIME_FIELD, EXPIRY_TIME_FIELD, POST_TRIGGER_COLLECTION_DURATION_FIELD, DIAGNOSTICS_MODE_FIELD, SPOOLING_MODE_FIELD, COMPRESSION_FIELD, PRIORITY_FIELD, SIGNALS_TO_COLLECT_FIELD, COLLECTION_SCHEME_FIELD, DATA_EXTRA_DIMENSIONS_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, DATA_DESTINATION_CONFIGS_FIELD));
    private final String name;
    private final String arn;
    private final String description;
    private final String signalCatalogArn;
    private final String targetArn;
    private final String status;
    private final Instant startTime;
    private final Instant expiryTime;
    private final Long postTriggerCollectionDuration;
    private final String diagnosticsMode;
    private final String spoolingMode;
    private final String compression;
    private final Integer priority;
    private final List<SignalInformation> signalsToCollect;
    private final CollectionScheme collectionScheme;
    private final List<String> dataExtraDimensions;
    private final Instant creationTime;
    private final Instant lastModificationTime;
    private final List<DataDestinationConfig> dataDestinationConfigs;

    private GetCampaignResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.signalCatalogArn = builder.signalCatalogArn;
        this.targetArn = builder.targetArn;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.expiryTime = builder.expiryTime;
        this.postTriggerCollectionDuration = builder.postTriggerCollectionDuration;
        this.diagnosticsMode = builder.diagnosticsMode;
        this.spoolingMode = builder.spoolingMode;
        this.compression = builder.compression;
        this.priority = builder.priority;
        this.signalsToCollect = builder.signalsToCollect;
        this.collectionScheme = builder.collectionScheme;
        this.dataExtraDimensions = builder.dataExtraDimensions;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.dataDestinationConfigs = builder.dataDestinationConfigs;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final String signalCatalogArn() {
        return this.signalCatalogArn;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final CampaignStatus status() {
        return CampaignStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant expiryTime() {
        return this.expiryTime;
    }

    public final Long postTriggerCollectionDuration() {
        return this.postTriggerCollectionDuration;
    }

    public final DiagnosticsMode diagnosticsMode() {
        return DiagnosticsMode.fromValue(this.diagnosticsMode);
    }

    public final String diagnosticsModeAsString() {
        return this.diagnosticsMode;
    }

    public final SpoolingMode spoolingMode() {
        return SpoolingMode.fromValue(this.spoolingMode);
    }

    public final String spoolingModeAsString() {
        return this.spoolingMode;
    }

    public final Compression compression() {
        return Compression.fromValue(this.compression);
    }

    public final String compressionAsString() {
        return this.compression;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final boolean hasSignalsToCollect() {
        return this.signalsToCollect != null && !(this.signalsToCollect instanceof SdkAutoConstructList);
    }

    public final List<SignalInformation> signalsToCollect() {
        return this.signalsToCollect;
    }

    public final CollectionScheme collectionScheme() {
        return this.collectionScheme;
    }

    public final boolean hasDataExtraDimensions() {
        return this.dataExtraDimensions != null && !(this.dataExtraDimensions instanceof SdkAutoConstructList);
    }

    public final List<String> dataExtraDimensions() {
        return this.dataExtraDimensions;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public final boolean hasDataDestinationConfigs() {
        return this.dataDestinationConfigs != null && !(this.dataDestinationConfigs instanceof SdkAutoConstructList);
    }

    public final List<DataDestinationConfig> dataDestinationConfigs() {
        return this.dataDestinationConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalCatalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.postTriggerCollectionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.diagnosticsModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spoolingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignalsToCollect() ? this.signalsToCollect() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionScheme());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataExtraDimensions() ? this.dataExtraDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataDestinationConfigs() ? this.dataDestinationConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCampaignResponse)) {
            return false;
        }
        GetCampaignResponse other = (GetCampaignResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.signalCatalogArn(), other.signalCatalogArn()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.expiryTime(), other.expiryTime()) && Objects.equals(this.postTriggerCollectionDuration(), other.postTriggerCollectionDuration()) && Objects.equals(this.diagnosticsModeAsString(), other.diagnosticsModeAsString()) && Objects.equals(this.spoolingModeAsString(), other.spoolingModeAsString()) && Objects.equals(this.compressionAsString(), other.compressionAsString()) && Objects.equals(this.priority(), other.priority()) && this.hasSignalsToCollect() == other.hasSignalsToCollect() && Objects.equals(this.signalsToCollect(), other.signalsToCollect()) && Objects.equals(this.collectionScheme(), other.collectionScheme()) && this.hasDataExtraDimensions() == other.hasDataExtraDimensions() && Objects.equals(this.dataExtraDimensions(), other.dataExtraDimensions()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime()) && this.hasDataDestinationConfigs() == other.hasDataDestinationConfigs() && Objects.equals(this.dataDestinationConfigs(), other.dataDestinationConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"GetCampaignResponse").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("SignalCatalogArn", (Object)this.signalCatalogArn()).add("TargetArn", (Object)this.targetArn()).add("Status", (Object)this.statusAsString()).add("StartTime", (Object)this.startTime()).add("ExpiryTime", (Object)this.expiryTime()).add("PostTriggerCollectionDuration", (Object)this.postTriggerCollectionDuration()).add("DiagnosticsMode", (Object)this.diagnosticsModeAsString()).add("SpoolingMode", (Object)this.spoolingModeAsString()).add("Compression", (Object)this.compressionAsString()).add("Priority", (Object)this.priority()).add("SignalsToCollect", this.hasSignalsToCollect() ? this.signalsToCollect() : null).add("CollectionScheme", (Object)this.collectionScheme()).add("DataExtraDimensions", this.hasDataExtraDimensions() ? this.dataExtraDimensions() : null).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).add("DataDestinationConfigs", this.hasDataDestinationConfigs() ? this.dataDestinationConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "signalCatalogArn": {
                return Optional.ofNullable(clazz.cast(this.signalCatalogArn()));
            }
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "expiryTime": {
                return Optional.ofNullable(clazz.cast(this.expiryTime()));
            }
            case "postTriggerCollectionDuration": {
                return Optional.ofNullable(clazz.cast(this.postTriggerCollectionDuration()));
            }
            case "diagnosticsMode": {
                return Optional.ofNullable(clazz.cast(this.diagnosticsModeAsString()));
            }
            case "spoolingMode": {
                return Optional.ofNullable(clazz.cast(this.spoolingModeAsString()));
            }
            case "compression": {
                return Optional.ofNullable(clazz.cast(this.compressionAsString()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "signalsToCollect": {
                return Optional.ofNullable(clazz.cast(this.signalsToCollect()));
            }
            case "collectionScheme": {
                return Optional.ofNullable(clazz.cast(this.collectionScheme()));
            }
            case "dataExtraDimensions": {
                return Optional.ofNullable(clazz.cast(this.dataExtraDimensions()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
            case "dataDestinationConfigs": {
                return Optional.ofNullable(clazz.cast(this.dataDestinationConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCampaignResponse, T> g) {
        return obj -> g.apply((GetCampaignResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseResponse.BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String description;
        private String signalCatalogArn;
        private String targetArn;
        private String status;
        private Instant startTime;
        private Instant expiryTime;
        private Long postTriggerCollectionDuration;
        private String diagnosticsMode;
        private String spoolingMode;
        private String compression;
        private Integer priority;
        private List<SignalInformation> signalsToCollect = DefaultSdkAutoConstructList.getInstance();
        private CollectionScheme collectionScheme;
        private List<String> dataExtraDimensions = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Instant lastModificationTime;
        private List<DataDestinationConfig> dataDestinationConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCampaignResponse model) {
            super(model);
            this.name(model.name);
            this.arn(model.arn);
            this.description(model.description);
            this.signalCatalogArn(model.signalCatalogArn);
            this.targetArn(model.targetArn);
            this.status(model.status);
            this.startTime(model.startTime);
            this.expiryTime(model.expiryTime);
            this.postTriggerCollectionDuration(model.postTriggerCollectionDuration);
            this.diagnosticsMode(model.diagnosticsMode);
            this.spoolingMode(model.spoolingMode);
            this.compression(model.compression);
            this.priority(model.priority);
            this.signalsToCollect(model.signalsToCollect);
            this.collectionScheme(model.collectionScheme);
            this.dataExtraDimensions(model.dataExtraDimensions);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
            this.dataDestinationConfigs(model.dataDestinationConfigs);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSignalCatalogArn() {
            return this.signalCatalogArn;
        }

        public final void setSignalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
        }

        @Override
        public final Builder signalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CampaignStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getExpiryTime() {
            return this.expiryTime;
        }

        public final void setExpiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
        }

        @Override
        public final Builder expiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public final Long getPostTriggerCollectionDuration() {
            return this.postTriggerCollectionDuration;
        }

        public final void setPostTriggerCollectionDuration(Long postTriggerCollectionDuration) {
            this.postTriggerCollectionDuration = postTriggerCollectionDuration;
        }

        @Override
        public final Builder postTriggerCollectionDuration(Long postTriggerCollectionDuration) {
            this.postTriggerCollectionDuration = postTriggerCollectionDuration;
            return this;
        }

        public final String getDiagnosticsMode() {
            return this.diagnosticsMode;
        }

        public final void setDiagnosticsMode(String diagnosticsMode) {
            this.diagnosticsMode = diagnosticsMode;
        }

        @Override
        public final Builder diagnosticsMode(String diagnosticsMode) {
            this.diagnosticsMode = diagnosticsMode;
            return this;
        }

        @Override
        public final Builder diagnosticsMode(DiagnosticsMode diagnosticsMode) {
            this.diagnosticsMode(diagnosticsMode == null ? null : diagnosticsMode.toString());
            return this;
        }

        public final String getSpoolingMode() {
            return this.spoolingMode;
        }

        public final void setSpoolingMode(String spoolingMode) {
            this.spoolingMode = spoolingMode;
        }

        @Override
        public final Builder spoolingMode(String spoolingMode) {
            this.spoolingMode = spoolingMode;
            return this;
        }

        @Override
        public final Builder spoolingMode(SpoolingMode spoolingMode) {
            this.spoolingMode(spoolingMode == null ? null : spoolingMode.toString());
            return this;
        }

        public final String getCompression() {
            return this.compression;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(Compression compression) {
            this.compression(compression == null ? null : compression.toString());
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final List<SignalInformation.Builder> getSignalsToCollect() {
            List<SignalInformation.Builder> result = SignalInformationListCopier.copyToBuilder(this.signalsToCollect);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignalsToCollect(Collection<SignalInformation.BuilderImpl> signalsToCollect) {
            this.signalsToCollect = SignalInformationListCopier.copyFromBuilder(signalsToCollect);
        }

        @Override
        public final Builder signalsToCollect(Collection<SignalInformation> signalsToCollect) {
            this.signalsToCollect = SignalInformationListCopier.copy(signalsToCollect);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalsToCollect(SignalInformation ... signalsToCollect) {
            this.signalsToCollect(Arrays.asList(signalsToCollect));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalsToCollect(Consumer<SignalInformation.Builder> ... signalsToCollect) {
            this.signalsToCollect(Stream.of(signalsToCollect).map(c -> (SignalInformation)((SignalInformation.Builder)SignalInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CollectionScheme.Builder getCollectionScheme() {
            return this.collectionScheme != null ? this.collectionScheme.toBuilder() : null;
        }

        public final void setCollectionScheme(CollectionScheme.BuilderImpl collectionScheme) {
            this.collectionScheme = collectionScheme != null ? collectionScheme.build() : null;
        }

        @Override
        public final Builder collectionScheme(CollectionScheme collectionScheme) {
            this.collectionScheme = collectionScheme;
            return this;
        }

        public final Collection<String> getDataExtraDimensions() {
            if (this.dataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataExtraDimensions;
        }

        public final void setDataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = DataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
        }

        @Override
        public final Builder dataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = DataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataExtraDimensions(String ... dataExtraDimensions) {
            this.dataExtraDimensions(Arrays.asList(dataExtraDimensions));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final List<DataDestinationConfig.Builder> getDataDestinationConfigs() {
            List<DataDestinationConfig.Builder> result = DataDestinationConfigsCopier.copyToBuilder(this.dataDestinationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataDestinationConfigs(Collection<DataDestinationConfig.BuilderImpl> dataDestinationConfigs) {
            this.dataDestinationConfigs = DataDestinationConfigsCopier.copyFromBuilder(dataDestinationConfigs);
        }

        @Override
        public final Builder dataDestinationConfigs(Collection<DataDestinationConfig> dataDestinationConfigs) {
            this.dataDestinationConfigs = DataDestinationConfigsCopier.copy(dataDestinationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataDestinationConfigs(DataDestinationConfig ... dataDestinationConfigs) {
            this.dataDestinationConfigs(Arrays.asList(dataDestinationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataDestinationConfigs(Consumer<DataDestinationConfig.Builder> ... dataDestinationConfigs) {
            this.dataDestinationConfigs(Stream.of(dataDestinationConfigs).map(c -> (DataDestinationConfig)((DataDestinationConfig.Builder)DataDestinationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetCampaignResponse build() {
            return new GetCampaignResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTFleetWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCampaignResponse> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder signalCatalogArn(String var1);

        public Builder targetArn(String var1);

        public Builder status(String var1);

        public Builder status(CampaignStatus var1);

        public Builder startTime(Instant var1);

        public Builder expiryTime(Instant var1);

        public Builder postTriggerCollectionDuration(Long var1);

        public Builder diagnosticsMode(String var1);

        public Builder diagnosticsMode(DiagnosticsMode var1);

        public Builder spoolingMode(String var1);

        public Builder spoolingMode(SpoolingMode var1);

        public Builder compression(String var1);

        public Builder compression(Compression var1);

        public Builder priority(Integer var1);

        public Builder signalsToCollect(Collection<SignalInformation> var1);

        public Builder signalsToCollect(SignalInformation ... var1);

        public Builder signalsToCollect(Consumer<SignalInformation.Builder> ... var1);

        public Builder collectionScheme(CollectionScheme var1);

        default public Builder collectionScheme(Consumer<CollectionScheme.Builder> collectionScheme) {
            return this.collectionScheme((CollectionScheme)((CollectionScheme.Builder)CollectionScheme.builder().applyMutation(collectionScheme)).build());
        }

        public Builder dataExtraDimensions(Collection<String> var1);

        public Builder dataExtraDimensions(String ... var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);

        public Builder dataDestinationConfigs(Collection<DataDestinationConfig> var1);

        public Builder dataDestinationConfigs(DataDestinationConfig ... var1);

        public Builder dataDestinationConfigs(Consumer<DataDestinationConfig.Builder> ... var1);
    }
}

