/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.StructuredMessage;
import software.amazon.awssdk.services.iotfleetwise.model.StructuredMessageListType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StructuredMessageListDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StructuredMessageListDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StructuredMessageListDefinition.getter(StructuredMessageListDefinition::name)).setter(StructuredMessageListDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<StructuredMessage> MEMBER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("memberType").getter(StructuredMessageListDefinition.getter(StructuredMessageListDefinition::memberType)).setter(StructuredMessageListDefinition.setter(Builder::memberType)).constructor(StructuredMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberType").build()}).build();
    private static final SdkField<String> LIST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listType").getter(StructuredMessageListDefinition.getter(StructuredMessageListDefinition::listTypeAsString)).setter(StructuredMessageListDefinition.setter(Builder::listType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listType").build()}).build();
    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("capacity").getter(StructuredMessageListDefinition.getter(StructuredMessageListDefinition::capacity)).setter(StructuredMessageListDefinition.setter(Builder::capacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MEMBER_TYPE_FIELD, LIST_TYPE_FIELD, CAPACITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final StructuredMessage memberType;
    private final String listType;
    private final Integer capacity;

    private StructuredMessageListDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.memberType = builder.memberType;
        this.listType = builder.listType;
        this.capacity = builder.capacity;
    }

    public final String name() {
        return this.name;
    }

    public final StructuredMessage memberType() {
        return this.memberType;
    }

    public final StructuredMessageListType listType() {
        return StructuredMessageListType.fromValue(this.listType);
    }

    public final String listTypeAsString() {
        return this.listType;
    }

    public final Integer capacity() {
        return this.capacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberType());
        hashCode = 31 * hashCode + Objects.hashCode(this.listTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StructuredMessageListDefinition)) {
            return false;
        }
        StructuredMessageListDefinition other = (StructuredMessageListDefinition)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.memberType(), other.memberType()) && Objects.equals(this.listTypeAsString(), other.listTypeAsString()) && Objects.equals(this.capacity(), other.capacity());
    }

    public final String toString() {
        return ToString.builder((String)"StructuredMessageListDefinition").add("Name", (Object)this.name()).add("MemberType", (Object)this.memberType()).add("ListType", (Object)this.listTypeAsString()).add("Capacity", (Object)this.capacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "memberType": {
                return Optional.ofNullable(clazz.cast(this.memberType()));
            }
            case "listType": {
                return Optional.ofNullable(clazz.cast(this.listTypeAsString()));
            }
            case "capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StructuredMessageListDefinition, T> g) {
        return obj -> g.apply((StructuredMessageListDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private StructuredMessage memberType;
        private String listType;
        private Integer capacity;

        private BuilderImpl() {
        }

        private BuilderImpl(StructuredMessageListDefinition model) {
            this.name(model.name);
            this.memberType(model.memberType);
            this.listType(model.listType);
            this.capacity(model.capacity);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StructuredMessage.Builder getMemberType() {
            return this.memberType != null ? this.memberType.toBuilder() : null;
        }

        public final void setMemberType(StructuredMessage.BuilderImpl memberType) {
            this.memberType = memberType != null ? memberType.build() : null;
        }

        @Override
        public final Builder memberType(StructuredMessage memberType) {
            this.memberType = memberType;
            return this;
        }

        public final String getListType() {
            return this.listType;
        }

        public final void setListType(String listType) {
            this.listType = listType;
        }

        @Override
        public final Builder listType(String listType) {
            this.listType = listType;
            return this;
        }

        @Override
        public final Builder listType(StructuredMessageListType listType) {
            this.listType(listType == null ? null : listType.toString());
            return this;
        }

        public final Integer getCapacity() {
            return this.capacity;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public StructuredMessageListDefinition build() {
            return new StructuredMessageListDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StructuredMessageListDefinition> {
        public Builder name(String var1);

        public Builder memberType(StructuredMessage var1);

        default public Builder memberType(Consumer<StructuredMessage.Builder> memberType) {
            return this.memberType((StructuredMessage)((StructuredMessage.Builder)StructuredMessage.builder().applyMutation(memberType)).build());
        }

        public Builder listType(String var1);

        public Builder listType(StructuredMessageListType var1);

        public Builder capacity(Integer var1);
    }
}

