/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkInterfaceType {
    CAN_INTERFACE("CAN_INTERFACE"),
    OBD_INTERFACE("OBD_INTERFACE"),
    VEHICLE_MIDDLEWARE("VEHICLE_MIDDLEWARE"),
    CUSTOMER_DECODED_INTERFACE("CUSTOMER_DECODED_INTERFACE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkInterfaceType> VALUE_MAP;
    private final String value;

    private NetworkInterfaceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkInterfaceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkInterfaceType> knownValues() {
        EnumSet<NetworkInterfaceType> knownValues = EnumSet.allOf(NetworkInterfaceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkInterfaceType.class, NetworkInterfaceType::toString);
    }
}

