/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVehicleRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<CreateVehicleRequest.Builder, CreateVehicleRequest> {
    private static final SdkField<String> VEHICLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vehicleName").getter(getter(CreateVehicleRequest::vehicleName)).setter(setter(Builder::vehicleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicleName").build()).build();

    private static final SdkField<String> MODEL_MANIFEST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelManifestArn").getter(getter(CreateVehicleRequest::modelManifestArn))
            .setter(setter(Builder::modelManifestArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelManifestArn").build()).build();

    private static final SdkField<String> DECODER_MANIFEST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("decoderManifestArn").getter(getter(CreateVehicleRequest::decoderManifestArn))
            .setter(setter(Builder::decoderManifestArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decoderManifestArn").build())
            .build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(CreateVehicleRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ASSOCIATION_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationBehavior").getter(getter(CreateVehicleRequest::associationBehaviorAsString))
            .setter(setter(Builder::associationBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationBehavior").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateVehicleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLE_NAME_FIELD,
            MODEL_MANIFEST_ARN_FIELD, DECODER_MANIFEST_ARN_FIELD, ATTRIBUTES_FIELD, ASSOCIATION_BEHAVIOR_FIELD, TAGS_FIELD));

    private final String vehicleName;

    private final String modelManifestArn;

    private final String decoderManifestArn;

    private final Map<String, String> attributes;

    private final String associationBehavior;

    private final List<Tag> tags;

    private CreateVehicleRequest(BuilderImpl builder) {
        super(builder);
        this.vehicleName = builder.vehicleName;
        this.modelManifestArn = builder.modelManifestArn;
        this.decoderManifestArn = builder.decoderManifestArn;
        this.attributes = builder.attributes;
        this.associationBehavior = builder.associationBehavior;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique ID of the vehicle to create.
     * </p>
     * 
     * @return The unique ID of the vehicle to create.
     */
    public final String vehicleName() {
        return vehicleName;
    }

    /**
     * <p>
     * The Amazon Resource Name ARN of a vehicle model.
     * </p>
     * 
     * @return The Amazon Resource Name ARN of a vehicle model.
     */
    public final String modelManifestArn() {
        return modelManifestArn;
    }

    /**
     * <p>
     * The ARN of a decoder manifest.
     * </p>
     * 
     * @return The ARN of a decoder manifest.
     */
    public final String decoderManifestArn() {
        return decoderManifestArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Static information about a vehicle in a key-value pair. For example: <code>"engineType"</code> :
     * <code>"1.3 L R2"</code>
     * </p>
     * <p>
     * A campaign must include the keys (attribute names) in <code>dataExtraDimensions</code> for them to display in
     * Amazon Timestream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Static information about a vehicle in a key-value pair. For example: <code>"engineType"</code> :
     *         <code>"1.3 L R2"</code> </p>
     *         <p>
     *         A campaign must include the keys (attribute names) in <code>dataExtraDimensions</code> for them to
     *         display in Amazon Timestream.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * An option to create a new Amazon Web Services IoT thing when creating a vehicle, or to validate an existing
     * Amazon Web Services IoT thing as a vehicle.
     * </p>
     * <p>
     * Default: <code/>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #associationBehavior} will return {@link VehicleAssociationBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #associationBehaviorAsString}.
     * </p>
     * 
     * @return An option to create a new Amazon Web Services IoT thing when creating a vehicle, or to validate an
     *         existing Amazon Web Services IoT thing as a vehicle. </p>
     *         <p>
     *         Default: <code/>
     * @see VehicleAssociationBehavior
     */
    public final VehicleAssociationBehavior associationBehavior() {
        return VehicleAssociationBehavior.fromValue(associationBehavior);
    }

    /**
     * <p>
     * An option to create a new Amazon Web Services IoT thing when creating a vehicle, or to validate an existing
     * Amazon Web Services IoT thing as a vehicle.
     * </p>
     * <p>
     * Default: <code/>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #associationBehavior} will return {@link VehicleAssociationBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #associationBehaviorAsString}.
     * </p>
     * 
     * @return An option to create a new Amazon Web Services IoT thing when creating a vehicle, or to validate an
     *         existing Amazon Web Services IoT thing as a vehicle. </p>
     *         <p>
     *         Default: <code/>
     * @see VehicleAssociationBehavior
     */
    public final String associationBehaviorAsString() {
        return associationBehavior;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata that can be used to manage the vehicle.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata that can be used to manage the vehicle.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vehicleName());
        hashCode = 31 * hashCode + Objects.hashCode(modelManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(decoderManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(associationBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVehicleRequest)) {
            return false;
        }
        CreateVehicleRequest other = (CreateVehicleRequest) obj;
        return Objects.equals(vehicleName(), other.vehicleName()) && Objects.equals(modelManifestArn(), other.modelManifestArn())
                && Objects.equals(decoderManifestArn(), other.decoderManifestArn()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes())
                && Objects.equals(associationBehaviorAsString(), other.associationBehaviorAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVehicleRequest").add("VehicleName", vehicleName())
                .add("ModelManifestArn", modelManifestArn()).add("DecoderManifestArn", decoderManifestArn())
                .add("Attributes", hasAttributes() ? attributes() : null)
                .add("AssociationBehavior", associationBehaviorAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vehicleName":
            return Optional.ofNullable(clazz.cast(vehicleName()));
        case "modelManifestArn":
            return Optional.ofNullable(clazz.cast(modelManifestArn()));
        case "decoderManifestArn":
            return Optional.ofNullable(clazz.cast(decoderManifestArn()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "associationBehavior":
            return Optional.ofNullable(clazz.cast(associationBehaviorAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVehicleRequest, T> g) {
        return obj -> g.apply((CreateVehicleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVehicleRequest> {
        /**
         * <p>
         * The unique ID of the vehicle to create.
         * </p>
         * 
         * @param vehicleName
         *        The unique ID of the vehicle to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vehicleName(String vehicleName);

        /**
         * <p>
         * The Amazon Resource Name ARN of a vehicle model.
         * </p>
         * 
         * @param modelManifestArn
         *        The Amazon Resource Name ARN of a vehicle model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelManifestArn(String modelManifestArn);

        /**
         * <p>
         * The ARN of a decoder manifest.
         * </p>
         * 
         * @param decoderManifestArn
         *        The ARN of a decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decoderManifestArn(String decoderManifestArn);

        /**
         * <p>
         * Static information about a vehicle in a key-value pair. For example: <code>"engineType"</code> :
         * <code>"1.3 L R2"</code>
         * </p>
         * <p>
         * A campaign must include the keys (attribute names) in <code>dataExtraDimensions</code> for them to display in
         * Amazon Timestream.
         * </p>
         * 
         * @param attributes
         *        Static information about a vehicle in a key-value pair. For example: <code>"engineType"</code> :
         *        <code>"1.3 L R2"</code> </p>
         *        <p>
         *        A campaign must include the keys (attribute names) in <code>dataExtraDimensions</code> for them to
         *        display in Amazon Timestream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * An option to create a new Amazon Web Services IoT thing when creating a vehicle, or to validate an existing
         * Amazon Web Services IoT thing as a vehicle.
         * </p>
         * <p>
         * Default: <code/>
         * </p>
         * 
         * @param associationBehavior
         *        An option to create a new Amazon Web Services IoT thing when creating a vehicle, or to validate an
         *        existing Amazon Web Services IoT thing as a vehicle. </p>
         *        <p>
         *        Default: <code/>
         * @see VehicleAssociationBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VehicleAssociationBehavior
         */
        Builder associationBehavior(String associationBehavior);

        /**
         * <p>
         * An option to create a new Amazon Web Services IoT thing when creating a vehicle, or to validate an existing
         * Amazon Web Services IoT thing as a vehicle.
         * </p>
         * <p>
         * Default: <code/>
         * </p>
         * 
         * @param associationBehavior
         *        An option to create a new Amazon Web Services IoT thing when creating a vehicle, or to validate an
         *        existing Amazon Web Services IoT thing as a vehicle. </p>
         *        <p>
         *        Default: <code/>
         * @see VehicleAssociationBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VehicleAssociationBehavior
         */
        Builder associationBehavior(VehicleAssociationBehavior associationBehavior);

        /**
         * <p>
         * Metadata that can be used to manage the vehicle.
         * </p>
         * 
         * @param tags
         *        Metadata that can be used to manage the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata that can be used to manage the vehicle.
         * </p>
         * 
         * @param tags
         *        Metadata that can be used to manage the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata that can be used to manage the vehicle.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotfleetwise.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private String vehicleName;

        private String modelManifestArn;

        private String decoderManifestArn;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String associationBehavior;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVehicleRequest model) {
            super(model);
            vehicleName(model.vehicleName);
            modelManifestArn(model.modelManifestArn);
            decoderManifestArn(model.decoderManifestArn);
            attributes(model.attributes);
            associationBehavior(model.associationBehavior);
            tags(model.tags);
        }

        public final String getVehicleName() {
            return vehicleName;
        }

        public final void setVehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
        }

        @Override
        public final Builder vehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
            return this;
        }

        public final String getModelManifestArn() {
            return modelManifestArn;
        }

        public final void setModelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
        }

        @Override
        public final Builder modelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
            return this;
        }

        public final String getDecoderManifestArn() {
            return decoderManifestArn;
        }

        public final void setDecoderManifestArn(String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
        }

        @Override
        public final Builder decoderManifestArn(String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = _attributesMapCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = _attributesMapCopier.copy(attributes);
            return this;
        }

        public final String getAssociationBehavior() {
            return associationBehavior;
        }

        public final void setAssociationBehavior(String associationBehavior) {
            this.associationBehavior = associationBehavior;
        }

        @Override
        public final Builder associationBehavior(String associationBehavior) {
            this.associationBehavior = associationBehavior;
            return this;
        }

        @Override
        public final Builder associationBehavior(VehicleAssociationBehavior associationBehavior) {
            this.associationBehavior(associationBehavior == null ? null : associationBehavior.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVehicleRequest build() {
            return new CreateVehicleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
