/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseAsyncClient;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.Node;

public class ListModelManifestNodesPublisher
implements SdkPublisher<ListModelManifestNodesResponse> {
    private final IoTFleetWiseAsyncClient client;
    private final ListModelManifestNodesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelManifestNodesPublisher(IoTFleetWiseAsyncClient client, ListModelManifestNodesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelManifestNodesPublisher(IoTFleetWiseAsyncClient client, ListModelManifestNodesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelManifestNodesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelManifestNodesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Node> nodes() {
        Function<ListModelManifestNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.nodes() != null) {
                return response.nodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListModelManifestNodesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListModelManifestNodesResponseFetcher
    implements AsyncPageFetcher<ListModelManifestNodesResponse> {
        private ListModelManifestNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListModelManifestNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelManifestNodesResponse> nextPage(ListModelManifestNodesResponse previousPage) {
            if (previousPage == null) {
                return ListModelManifestNodesPublisher.this.client.listModelManifestNodes(ListModelManifestNodesPublisher.this.firstRequest);
            }
            return ListModelManifestNodesPublisher.this.client.listModelManifestNodes((ListModelManifestNodesRequest)((Object)ListModelManifestNodesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

