/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseAsyncClient;
import software.amazon.awssdk.services.iotfleetwise.model.DecoderManifestSummary;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse;

public class ListDecoderManifestsPublisher
implements SdkPublisher<ListDecoderManifestsResponse> {
    private final IoTFleetWiseAsyncClient client;
    private final ListDecoderManifestsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDecoderManifestsPublisher(IoTFleetWiseAsyncClient client, ListDecoderManifestsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDecoderManifestsPublisher(IoTFleetWiseAsyncClient client, ListDecoderManifestsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDecoderManifestsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDecoderManifestsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DecoderManifestSummary> summaries() {
        Function<ListDecoderManifestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDecoderManifestsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDecoderManifestsResponseFetcher
    implements AsyncPageFetcher<ListDecoderManifestsResponse> {
        private ListDecoderManifestsResponseFetcher() {
        }

        public boolean hasNextPage(ListDecoderManifestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDecoderManifestsResponse> nextPage(ListDecoderManifestsResponse previousPage) {
            if (previousPage == null) {
                return ListDecoderManifestsPublisher.this.client.listDecoderManifests(ListDecoderManifestsPublisher.this.firstRequest);
            }
            return ListDecoderManifestsPublisher.this.client.listDecoderManifests((ListDecoderManifestsRequest)((Object)ListDecoderManifestsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

