/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.FleetSummary;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse;

public class ListFleetsIterable
implements SdkIterable<ListFleetsResponse> {
    private final IoTFleetWiseClient client;
    private final ListFleetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFleetsIterable(IoTFleetWiseClient client, ListFleetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFleetsResponseFetcher();
    }

    public Iterator<ListFleetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FleetSummary> fleetSummaries() {
        Function<ListFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleetSummaries() != null) {
                return response.fleetSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFleetsResponseFetcher
    implements SyncPageFetcher<ListFleetsResponse> {
        private ListFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFleetsResponse nextPage(ListFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListFleetsIterable.this.client.listFleets(ListFleetsIterable.this.firstRequest);
            }
            return ListFleetsIterable.this.client.listFleets((ListFleetsRequest)((Object)ListFleetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

