/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleethub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleethub.model.ApplicationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(ApplicationSummary.getter(ApplicationSummary::applicationId)).setter(ApplicationSummary.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationName").getter(ApplicationSummary.getter(ApplicationSummary::applicationName)).setter(ApplicationSummary.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationDescription").getter(ApplicationSummary.getter(ApplicationSummary::applicationDescription)).setter(ApplicationSummary.setter(Builder::applicationDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationDescription").build()}).build();
    private static final SdkField<String> APPLICATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationUrl").getter(ApplicationSummary.getter(ApplicationSummary::applicationUrl)).setter(ApplicationSummary.setter(Builder::applicationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationUrl").build()}).build();
    private static final SdkField<Long> APPLICATION_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("applicationCreationDate").getter(ApplicationSummary.getter(ApplicationSummary::applicationCreationDate)).setter(ApplicationSummary.setter(Builder::applicationCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationCreationDate").build()}).build();
    private static final SdkField<Long> APPLICATION_LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("applicationLastUpdateDate").getter(ApplicationSummary.getter(ApplicationSummary::applicationLastUpdateDate)).setter(ApplicationSummary.setter(Builder::applicationLastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationLastUpdateDate").build()}).build();
    private static final SdkField<String> APPLICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationState").getter(ApplicationSummary.getter(ApplicationSummary::applicationStateAsString)).setter(ApplicationSummary.setter(Builder::applicationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, APPLICATION_NAME_FIELD, APPLICATION_DESCRIPTION_FIELD, APPLICATION_URL_FIELD, APPLICATION_CREATION_DATE_FIELD, APPLICATION_LAST_UPDATE_DATE_FIELD, APPLICATION_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String applicationName;
    private final String applicationDescription;
    private final String applicationUrl;
    private final Long applicationCreationDate;
    private final Long applicationLastUpdateDate;
    private final String applicationState;

    private ApplicationSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.applicationUrl = builder.applicationUrl;
        this.applicationCreationDate = builder.applicationCreationDate;
        this.applicationLastUpdateDate = builder.applicationLastUpdateDate;
        this.applicationState = builder.applicationState;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String applicationDescription() {
        return this.applicationDescription;
    }

    public final String applicationUrl() {
        return this.applicationUrl;
    }

    public final Long applicationCreationDate() {
        return this.applicationCreationDate;
    }

    public final Long applicationLastUpdateDate() {
        return this.applicationLastUpdateDate;
    }

    public final ApplicationState applicationState() {
        return ApplicationState.fromValue(this.applicationState);
    }

    public final String applicationStateAsString() {
        return this.applicationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.applicationDescription(), other.applicationDescription()) && Objects.equals(this.applicationUrl(), other.applicationUrl()) && Objects.equals(this.applicationCreationDate(), other.applicationCreationDate()) && Objects.equals(this.applicationLastUpdateDate(), other.applicationLastUpdateDate()) && Objects.equals(this.applicationStateAsString(), other.applicationStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationSummary").add("ApplicationId", (Object)this.applicationId()).add("ApplicationName", (Object)this.applicationName()).add("ApplicationDescription", (Object)this.applicationDescription()).add("ApplicationUrl", (Object)this.applicationUrl()).add("ApplicationCreationDate", (Object)this.applicationCreationDate()).add("ApplicationLastUpdateDate", (Object)this.applicationLastUpdateDate()).add("ApplicationState", (Object)this.applicationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "applicationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationDescription()));
            }
            case "applicationUrl": {
                return Optional.ofNullable(clazz.cast(this.applicationUrl()));
            }
            case "applicationCreationDate": {
                return Optional.ofNullable(clazz.cast(this.applicationCreationDate()));
            }
            case "applicationLastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.applicationLastUpdateDate()));
            }
            case "applicationState": {
                return Optional.ofNullable(clazz.cast(this.applicationStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("applicationName", APPLICATION_NAME_FIELD);
        map.put("applicationDescription", APPLICATION_DESCRIPTION_FIELD);
        map.put("applicationUrl", APPLICATION_URL_FIELD);
        map.put("applicationCreationDate", APPLICATION_CREATION_DATE_FIELD);
        map.put("applicationLastUpdateDate", APPLICATION_LAST_UPDATE_DATE_FIELD);
        map.put("applicationState", APPLICATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSummary, T> g) {
        return obj -> g.apply((ApplicationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String applicationName;
        private String applicationDescription;
        private String applicationUrl;
        private Long applicationCreationDate;
        private Long applicationLastUpdateDate;
        private String applicationState;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            this.applicationId(model.applicationId);
            this.applicationName(model.applicationName);
            this.applicationDescription(model.applicationDescription);
            this.applicationUrl(model.applicationUrl);
            this.applicationCreationDate(model.applicationCreationDate);
            this.applicationLastUpdateDate(model.applicationLastUpdateDate);
            this.applicationState(model.applicationState);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getApplicationDescription() {
            return this.applicationDescription;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final String getApplicationUrl() {
            return this.applicationUrl;
        }

        public final void setApplicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
        }

        @Override
        public final Builder applicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
            return this;
        }

        public final Long getApplicationCreationDate() {
            return this.applicationCreationDate;
        }

        public final void setApplicationCreationDate(Long applicationCreationDate) {
            this.applicationCreationDate = applicationCreationDate;
        }

        @Override
        public final Builder applicationCreationDate(Long applicationCreationDate) {
            this.applicationCreationDate = applicationCreationDate;
            return this;
        }

        public final Long getApplicationLastUpdateDate() {
            return this.applicationLastUpdateDate;
        }

        public final void setApplicationLastUpdateDate(Long applicationLastUpdateDate) {
            this.applicationLastUpdateDate = applicationLastUpdateDate;
        }

        @Override
        public final Builder applicationLastUpdateDate(Long applicationLastUpdateDate) {
            this.applicationLastUpdateDate = applicationLastUpdateDate;
            return this;
        }

        public final String getApplicationState() {
            return this.applicationState;
        }

        public final void setApplicationState(String applicationState) {
            this.applicationState = applicationState;
        }

        @Override
        public final Builder applicationState(String applicationState) {
            this.applicationState = applicationState;
            return this;
        }

        @Override
        public final Builder applicationState(ApplicationState applicationState) {
            this.applicationState(applicationState == null ? null : applicationState.toString());
            return this;
        }

        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationSummary> {
        public Builder applicationId(String var1);

        public Builder applicationName(String var1);

        public Builder applicationDescription(String var1);

        public Builder applicationUrl(String var1);

        public Builder applicationCreationDate(Long var1);

        public Builder applicationLastUpdateDate(Long var1);

        public Builder applicationState(String var1);

        public Builder applicationState(ApplicationState var1);
    }
}

