/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ioteventsdata.model.DetectorState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Detector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Detector> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorModelName").getter(Detector.getter(Detector::detectorModelName)).setter(Detector.setter(Builder::detectorModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()}).build();
    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyValue").getter(Detector.getter(Detector::keyValue)).setter(Detector.setter(Builder::keyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()}).build();
    private static final SdkField<String> DETECTOR_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorModelVersion").getter(Detector.getter(Detector::detectorModelVersion)).setter(Detector.setter(Builder::detectorModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelVersion").build()}).build();
    private static final SdkField<DetectorState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(Detector.getter(Detector::state)).setter(Detector.setter(Builder::state)).constructor(DetectorState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(Detector.getter(Detector::creationTime)).setter(Detector.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(Detector.getter(Detector::lastUpdateTime)).setter(Detector.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD, KEY_VALUE_FIELD, DETECTOR_MODEL_VERSION_FIELD, STATE_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Detector.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String detectorModelName;
    private final String keyValue;
    private final String detectorModelVersion;
    private final DetectorState state;
    private final Instant creationTime;
    private final Instant lastUpdateTime;

    private Detector(BuilderImpl builder) {
        this.detectorModelName = builder.detectorModelName;
        this.keyValue = builder.keyValue;
        this.detectorModelVersion = builder.detectorModelVersion;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public final String detectorModelName() {
        return this.detectorModelName;
    }

    public final String keyValue() {
        return this.keyValue;
    }

    public final String detectorModelVersion() {
        return this.detectorModelVersion;
    }

    public final DetectorState state() {
        return this.state;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Detector)) {
            return false;
        }
        Detector other = (Detector)obj;
        return Objects.equals(this.detectorModelName(), other.detectorModelName()) && Objects.equals(this.keyValue(), other.keyValue()) && Objects.equals(this.detectorModelVersion(), other.detectorModelVersion()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"Detector").add("DetectorModelName", (Object)this.detectorModelName()).add("KeyValue", (Object)this.keyValue()).add("DetectorModelVersion", (Object)this.detectorModelVersion()).add("State", (Object)this.state()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorModelName": {
                return Optional.ofNullable(clazz.cast(this.detectorModelName()));
            }
            case "keyValue": {
                return Optional.ofNullable(clazz.cast(this.keyValue()));
            }
            case "detectorModelVersion": {
                return Optional.ofNullable(clazz.cast(this.detectorModelVersion()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detectorModelName", DETECTOR_MODEL_NAME_FIELD);
        map.put("keyValue", KEY_VALUE_FIELD);
        map.put("detectorModelVersion", DETECTOR_MODEL_VERSION_FIELD);
        map.put("state", STATE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Detector, T> g) {
        return obj -> g.apply((Detector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String detectorModelName;
        private String keyValue;
        private String detectorModelVersion;
        private DetectorState state;
        private Instant creationTime;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Detector model) {
            this.detectorModelName(model.detectorModelName);
            this.keyValue(model.keyValue);
            this.detectorModelVersion(model.detectorModelVersion);
            this.state(model.state);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getDetectorModelName() {
            return this.detectorModelName;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final String getKeyValue() {
            return this.keyValue;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final String getDetectorModelVersion() {
            return this.detectorModelVersion;
        }

        public final void setDetectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
        }

        @Override
        public final Builder detectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
            return this;
        }

        public final DetectorState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(DetectorState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(DetectorState state) {
            this.state = state;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public Detector build() {
            return new Detector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Detector> {
        public Builder detectorModelName(String var1);

        public Builder keyValue(String var1);

        public Builder detectorModelVersion(String var1);

        public Builder state(DetectorState var1);

        default public Builder state(Consumer<DetectorState.Builder> state) {
            return this.state((DetectorState)((DetectorState.Builder)DetectorState.builder().applyMutation(state)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

