/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AlarmStateName {
    DISABLED("DISABLED"),
    NORMAL("NORMAL"),
    ACTIVE("ACTIVE"),
    ACKNOWLEDGED("ACKNOWLEDGED"),
    SNOOZE_DISABLED("SNOOZE_DISABLED"),
    LATCHED("LATCHED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AlarmStateName> VALUE_MAP;
    private final String value;

    private AlarmStateName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AlarmStateName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AlarmStateName> knownValues() {
        EnumSet<AlarmStateName> knownValues = EnumSet.allOf(AlarmStateName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AlarmStateName.class, AlarmStateName::toString);
    }
}

